/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.metrics;

import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.ArrayList;
import java.util.List;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryMXBean;
import org.apache.bookkeeper.mledger.impl.cache.RangeEntryCacheImpl;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.metrics.AbstractMetrics;
import org.apache.pulsar.common.stats.Metrics;

public class ManagedLedgerCacheMetrics
extends AbstractMetrics {
    private List<Metrics> metrics = new ArrayList<Metrics>();

    public ManagedLedgerCacheMetrics(PulsarService pulsar) {
        super(pulsar);
    }

    @Override
    public synchronized List<Metrics> generate() {
        ManagedLedgerFactoryMXBean mlCacheStats = this.getManagedLedgerCacheStats();
        Metrics m = this.createMetrics();
        m.put("brk_ml_count", (Object)mlCacheStats.getNumberOfManagedLedgers());
        m.put("brk_ml_cache_used_size", (Object)mlCacheStats.getCacheUsedSize());
        m.put("brk_ml_cache_inserted_entries_total", (Object)mlCacheStats.getCacheInsertedEntriesCount());
        m.put("brk_ml_cache_evicted_entries_total", (Object)mlCacheStats.getCacheEvictedEntriesCount());
        m.put("brk_ml_cache_entries", (Object)mlCacheStats.getCacheEntriesCount());
        m.put("brk_ml_cache_evictions", (Object)mlCacheStats.getNumberOfCacheEvictions());
        m.put("brk_ml_cache_hits_rate", (Object)mlCacheStats.getCacheHitsRate());
        m.put("brk_ml_cache_misses_rate", (Object)mlCacheStats.getCacheMissesRate());
        m.put("brk_ml_cache_hits_throughput", (Object)mlCacheStats.getCacheHitsThroughput());
        m.put("brk_ml_cache_misses_throughput", (Object)mlCacheStats.getCacheMissesThroughput());
        PooledByteBufAllocator allocator = RangeEntryCacheImpl.ALLOCATOR;
        long activeAllocations = 0L;
        long activeAllocationsSmall = 0L;
        long activeAllocationsNormal = 0L;
        long activeAllocationsHuge = 0L;
        long totalAllocated = 0L;
        long totalUsed = 0L;
        for (PoolArenaMetric arena : allocator.metric().directArenas()) {
            activeAllocations += arena.numActiveAllocations();
            activeAllocationsSmall += arena.numActiveSmallAllocations();
            activeAllocationsNormal += arena.numActiveNormalAllocations();
            activeAllocationsHuge += arena.numActiveHugeAllocations();
            for (PoolChunkListMetric list : arena.chunkLists()) {
                for (PoolChunkMetric chunk : list) {
                    int size = chunk.chunkSize();
                    int used = size - chunk.freeBytes();
                    totalAllocated += (long)size;
                    totalUsed += (long)used;
                }
            }
        }
        m.put("brk_ml_cache_pool_allocated", (Object)totalAllocated);
        m.put("brk_ml_cache_pool_used", (Object)totalUsed);
        m.put("brk_ml_cache_pool_active_allocations", (Object)activeAllocations);
        m.put("brk_ml_cache_pool_active_allocations_small", (Object)activeAllocationsSmall);
        m.put("brk_ml_cache_pool_active_allocations_normal", (Object)activeAllocationsNormal);
        m.put("brk_ml_cache_pool_active_allocations_huge", (Object)activeAllocationsHuge);
        this.metrics.clear();
        this.metrics.add(m);
        return this.metrics;
    }
}

