/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.server.testing;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.discovery.server.EmbeddedDiscoveryModule;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.testing.TestingJmxModule;
import io.airlift.json.JsonModule;
import io.airlift.node.testing.TestingNodeModule;
import java.net.URI;
import org.weakref.jmx.guice.MBeanModule;

public class TestingDiscoveryServer
implements AutoCloseable {
    private final LifeCycleManager lifeCycleManager;
    private final TestingHttpServer server;

    public TestingDiscoveryServer(String environment) {
        Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new TestingNodeModule(environment), new TestingHttpServerModule(), new JsonModule(), new JaxrsModule(), new TestingJmxModule(), new DiscoveryModule(), new EmbeddedDiscoveryModule()});
        Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperty("discovery.store-cache-ttl", "0ms").quiet().initialize();
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        this.server = (TestingHttpServer)injector.getInstance(TestingHttpServer.class);
    }

    public URI getBaseUrl() {
        return this.server.getBaseUrl();
    }

    @Override
    public void close() throws Exception {
        if (this.lifeCycleManager != null) {
            this.lifeCycleManager.stop();
        }
    }
}

