/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.collect.ImmutableSet;
import io.trino.connector.CatalogName;
import io.trino.metadata.InternalNodeManager;
import io.trino.spi.Node;
import io.trino.spi.NodeManager;
import java.util.Objects;
import java.util.Set;

public class ConnectorAwareNodeManager
implements NodeManager {
    private final InternalNodeManager nodeManager;
    private final String environment;
    private final CatalogName catalogName;
    private final boolean schedulerIncludeCoordinator;

    public ConnectorAwareNodeManager(InternalNodeManager nodeManager, String environment, CatalogName catalogName, boolean schedulerIncludeCoordinator) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.schedulerIncludeCoordinator = schedulerIncludeCoordinator;
    }

    public Set<Node> getAllNodes() {
        return ImmutableSet.builder().addAll(this.nodeManager.getActiveConnectorNodes(this.catalogName)).add((Object)this.nodeManager.getCurrentNode()).build();
    }

    public Set<Node> getWorkerNodes() {
        ImmutableSet.Builder nodes = ImmutableSet.builder();
        this.nodeManager.getActiveConnectorNodes(this.catalogName).stream().filter(node -> !node.isCoordinator() || this.schedulerIncludeCoordinator).forEach(arg_0 -> ((ImmutableSet.Builder)nodes).add(arg_0));
        if (!this.nodeManager.getCurrentNode().isCoordinator() || this.schedulerIncludeCoordinator) {
            nodes.add((Object)this.getCurrentNode());
        }
        return nodes.build();
    }

    public Node getCurrentNode() {
        return this.nodeManager.getCurrentNode();
    }

    public String getEnvironment() {
        return this.environment;
    }
}

