/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.resourcegroups.ResourceGroupId;
import java.util.Objects;

public class QueryQueueFullException
extends TrinoException {
    private final ResourceGroupId resourceGroup;

    public QueryQueueFullException(ResourceGroupId resourceGroup) {
        super((ErrorCodeSupplier)StandardErrorCode.QUERY_QUEUE_FULL, String.format("Too many queued queries for \"%s\"", resourceGroup));
        this.resourceGroup = Objects.requireNonNull(resourceGroup, "resourceGroup is null");
    }

    public ResourceGroupId getResourceGroup() {
        return this.resourceGroup;
    }
}

