/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import com.google.common.math.LongMath;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
class ResourceUsage {
    private final long cpuUsageMillis;
    private final long memoryUsageBytes;

    public ResourceUsage(long cpuUsageMillis, long memoryUsageBytes) {
        this.cpuUsageMillis = cpuUsageMillis;
        this.memoryUsageBytes = memoryUsageBytes;
    }

    public ResourceUsage clone() {
        return new ResourceUsage(this.cpuUsageMillis, this.memoryUsageBytes);
    }

    public ResourceUsage add(ResourceUsage other) {
        long newCpuUsageMillis = LongMath.saturatedAdd((long)this.cpuUsageMillis, (long)other.cpuUsageMillis);
        long newMemoryUsageBytes = LongMath.saturatedAdd((long)this.memoryUsageBytes, (long)other.memoryUsageBytes);
        return new ResourceUsage(newCpuUsageMillis, newMemoryUsageBytes);
    }

    public ResourceUsage subtract(ResourceUsage other) {
        long newCpuUsageMillis = LongMath.saturatedSubtract((long)this.cpuUsageMillis, (long)other.cpuUsageMillis);
        long newMemoryUsageBytes = LongMath.saturatedSubtract((long)this.memoryUsageBytes, (long)other.memoryUsageBytes);
        return new ResourceUsage(newCpuUsageMillis, newMemoryUsageBytes);
    }

    public long getCpuUsageMillis() {
        return this.cpuUsageMillis;
    }

    public long getMemoryUsageBytes() {
        return this.memoryUsageBytes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResourceUsage otherUsage = (ResourceUsage)other;
        return this.cpuUsageMillis == otherUsage.cpuUsageMillis && this.memoryUsageBytes == otherUsage.memoryUsageBytes;
    }

    public int hashCode() {
        return Objects.hash(this.cpuUsageMillis, this.memoryUsageBytes);
    }
}

