/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;

public class InternalTable {
    private final Map<String, Integer> columnIndexes;
    private final List<Page> pages;

    public InternalTable(Map<String, Integer> columnIndexes, Iterable<Page> pages) {
        this.columnIndexes = ImmutableMap.copyOf(Objects.requireNonNull(columnIndexes, "columnIndexes is null"));
        this.pages = ImmutableList.copyOf(Objects.requireNonNull(pages, "pages is null"));
    }

    public int getColumnIndex(String columnName) {
        Integer index = this.columnIndexes.get(columnName);
        Preconditions.checkArgument((index != null ? 1 : 0) != 0, (String)"Column '%s' not found", (Object)columnName);
        return index;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public static Builder builder(ColumnMetadata ... columns) {
        return InternalTable.builder((List<ColumnMetadata>)ImmutableList.copyOf((Object[])columns));
    }

    public static Builder builder(List<ColumnMetadata> columns) {
        ImmutableList.Builder names = ImmutableList.builder();
        ImmutableList.Builder types = ImmutableList.builder();
        for (ColumnMetadata column : columns) {
            names.add((Object)column.getName());
            types.add((Object)column.getType());
        }
        return new Builder((List<String>)names.build(), (List<Type>)types.build());
    }

    public static class Builder {
        private final Map<String, Integer> columnIndexes;
        private final List<Type> types;
        private final List<Page> pages;
        private final PageBuilder pageBuilder;
        private long recordCount;

        public Builder(List<String> columnNames, List<Type> types) {
            Objects.requireNonNull(columnNames, "columnNames is null");
            ImmutableMap.Builder columnIndexes = ImmutableMap.builder();
            int columnIndex = 0;
            for (String columnName : columnNames) {
                columnIndexes.put((Object)columnName, (Object)columnIndex++);
            }
            this.columnIndexes = columnIndexes.build();
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            Preconditions.checkArgument((columnNames.size() == types.size() ? 1 : 0) != 0, (String)"Column name count does not match type count: columnNames=%s, types=%s", columnNames, (int)types.size());
            this.pages = new ArrayList<Page>();
            this.pageBuilder = new PageBuilder(types);
            this.recordCount = 0L;
        }

        public Builder add(Object ... values) {
            this.pageBuilder.declarePosition();
            for (int i = 0; i < this.types.size(); ++i) {
                TypeUtils.writeNativeValue((Type)this.types.get(i), (BlockBuilder)this.pageBuilder.getBlockBuilder(i), (Object)values[i]);
            }
            if (this.pageBuilder.isFull()) {
                this.flushPage();
            }
            ++this.recordCount;
            return this;
        }

        public boolean atLimit(OptionalLong limit) {
            return limit.isPresent() && this.recordCount >= limit.getAsLong();
        }

        public InternalTable build() {
            this.flushPage();
            return new InternalTable(this.columnIndexes, this.pages);
        }

        private void flushPage() {
            if (!this.pageBuilder.isEmpty()) {
                this.pages.add(this.pageBuilder.build());
                this.pageBuilder.reset();
            }
        }
    }
}

