/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.type.BlockTypeOperators;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DistinctLimitOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext localUserMemoryContext;
    private Page inputPage;
    private long remainingLimit;
    private boolean finishing;
    private final int[] outputChannels;
    private final GroupByHash groupByHash;
    private long nextDistinctId;
    private GroupByIdBlock groupByIds;
    private Work<GroupByIdBlock> unfinishedWork;

    public DistinctLimitOperator(OperatorContext operatorContext, List<Integer> distinctChannels, List<Type> distinctTypes, long limit, Optional<Integer> hashChannel, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.localUserMemoryContext = operatorContext.localUserMemoryContext();
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
        Objects.requireNonNull(hashChannel, "hashChannel is null");
        int[] distinctChannelInts = Ints.toArray((Collection)Objects.requireNonNull(distinctChannels, "distinctChannels is null"));
        if (hashChannel.isPresent()) {
            this.outputChannels = Arrays.copyOf(distinctChannelInts, distinctChannelInts.length + 1);
            this.outputChannels[distinctChannelInts.length] = hashChannel.get();
        } else {
            this.outputChannels = (int[])distinctChannelInts.clone();
        }
        this.groupByHash = GroupByHash.createGroupByHash(operatorContext.getSession(), distinctTypes, distinctChannelInts, hashChannel, Math.toIntExact(Math.min(limit, 10000L)), joinCompiler, blockTypeOperators, this::updateMemoryReservation);
        this.remainingLimit = limit;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return !this.hasUnfinishedInput() && (this.finishing || this.remainingLimit == 0L);
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.remainingLimit > 0L && !this.hasUnfinishedInput();
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput());
        this.inputPage = page;
        this.unfinishedWork = this.groupByHash.getGroupIds(page);
        this.processUnfinishedWork();
        this.updateMemoryReservation();
    }

    @Override
    public Page getOutput() {
        if (this.unfinishedWork != null && !this.processUnfinishedWork()) {
            return null;
        }
        if (this.groupByIds == null) {
            return null;
        }
        Verify.verifyNotNull((Object)this.inputPage);
        long resultingPositions = Math.min(this.groupByIds.getGroupCount() - this.nextDistinctId, this.remainingLimit);
        Page result = null;
        if (resultingPositions > 0L) {
            int[] distinctPositions = new int[Math.toIntExact(resultingPositions)];
            int distinctCount = 0;
            for (int position = 0; position < this.groupByIds.getPositionCount() && distinctCount < distinctPositions.length; ++position) {
                if (this.groupByIds.getGroupId(position) != this.nextDistinctId) continue;
                distinctPositions[distinctCount++] = position;
                ++this.nextDistinctId;
            }
            Verify.verify((distinctCount == distinctPositions.length ? 1 : 0) != 0);
            this.remainingLimit -= (long)distinctCount;
            result = this.inputPage.getColumns(this.outputChannels).getPositions(distinctPositions, 0, distinctPositions.length);
        }
        this.groupByIds = null;
        this.inputPage = null;
        this.updateMemoryReservation();
        return result;
    }

    private boolean processUnfinishedWork() {
        Verify.verifyNotNull(this.unfinishedWork);
        if (!this.unfinishedWork.process()) {
            return false;
        }
        this.groupByIds = this.unfinishedWork.getResult();
        this.unfinishedWork = null;
        return true;
    }

    private boolean hasUnfinishedInput() {
        return this.inputPage != null || this.unfinishedWork != null;
    }

    private boolean updateMemoryReservation() {
        this.localUserMemoryContext.setBytes(this.groupByHash.getEstimatedSize());
        return this.operatorContext.isWaitingForMemory().isDone();
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.groupByHash.getCapacity();
    }

    public static class DistinctLimitOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Integer> distinctChannels;
        private final List<Type> sourceTypes;
        private final long limit;
        private final Optional<Integer> hashChannel;
        private boolean closed;
        private final JoinCompiler joinCompiler;
        private final BlockTypeOperators blockTypeOperators;

        public DistinctLimitOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> sourceTypes, List<Integer> distinctChannels, long limit, Optional<Integer> hashChannel, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceTypes, "sourceTypes is null"));
            this.distinctChannels = Objects.requireNonNull(distinctChannels, "distinctChannels is null");
            Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
            this.limit = limit;
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
            this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, DistinctLimitOperator.class.getSimpleName());
            List distinctTypes = (List)this.distinctChannels.stream().map(this.sourceTypes::get).collect(ImmutableList.toImmutableList());
            return new DistinctLimitOperator(operatorContext, this.distinctChannels, distinctTypes, this.limit, this.hashChannel, this.joinCompiler, this.blockTypeOperators);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new DistinctLimitOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.distinctChannels, this.limit, this.hashChannel, this.joinCompiler, this.blockTypeOperators);
        }
    }
}

