/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.NullableDoubleState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;

public class NullableDoubleStateSerializer
implements AccumulatorStateSerializer<NullableDoubleState> {
    public Type getSerializedType() {
        return DoubleType.DOUBLE;
    }

    public void serialize(NullableDoubleState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            DoubleType.DOUBLE.writeDouble(out, state.getValue());
        }
    }

    public void deserialize(Block block, int index, NullableDoubleState state) {
        if (block.isNull(index)) {
            state.setNull(true);
        } else {
            state.setNull(false);
            state.setValue(DoubleType.DOUBLE.getDouble(block, index));
        }
    }
}

