/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.operator.PartitionFunction;
import io.trino.operator.exchange.LocalExchangeMemoryManager;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.operator.exchange.PageReference;
import io.trino.spi.Page;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class PartitioningExchanger
implements LocalExchanger {
    private final List<Consumer<PageReference>> buffers;
    private final LocalExchangeMemoryManager memoryManager;
    private final Function<Page, Page> partitionedPagePreparer;
    private final PartitionFunction partitionFunction;
    @GuardedBy(value="this")
    private final IntArrayList[] partitionAssignments;
    private final PageReference.PageReleasedListener onPageReleased;

    public PartitioningExchanger(List<Consumer<PageReference>> partitions, LocalExchangeMemoryManager memoryManager, Function<Page, Page> partitionPagePreparer, PartitionFunction partitionFunction) {
        this.buffers = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitions, "partitions is null"));
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.onPageReleased = PageReference.PageReleasedListener.forLocalExchangeMemoryManager(memoryManager);
        this.partitionedPagePreparer = Objects.requireNonNull(partitionPagePreparer, "partitionPagePreparer is null");
        this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
        this.partitionAssignments = new IntArrayList[partitions.size()];
        for (int i = 0; i < this.partitionAssignments.length; ++i) {
            this.partitionAssignments[i] = new IntArrayList();
        }
    }

    @Override
    public void accept(Page page) {
        Consumer<PageReference> wholePagePartition = this.partitionPageOrFindWholePagePartition(page, this.partitionedPagePreparer.apply(page));
        if (wholePagePartition != null) {
            page.compact();
            this.sendPageToPartition(wholePagePartition, page);
        }
    }

    @Nullable
    private synchronized Consumer<PageReference> partitionPageOrFindWholePagePartition(Page page, Page partitionPage) {
        for (int position = 0; position < partitionPage.getPositionCount(); ++position) {
            int partition = this.partitionFunction.getPartition(partitionPage, position);
            this.partitionAssignments[partition].add(position);
        }
        for (int partition = 0; partition < this.partitionAssignments.length; ++partition) {
            IntArrayList positionsList = this.partitionAssignments[partition];
            int partitionSize = positionsList.size();
            if (partitionSize == 0) continue;
            int[] positions = positionsList.elements();
            positionsList.clear();
            if (partitionSize == page.getPositionCount()) {
                return this.buffers.get(partition);
            }
            Page pageSplit = page.copyPositions(positions, 0, partitionSize);
            this.sendPageToPartition(this.buffers.get(partition), pageSplit);
        }
        return null;
    }

    private void sendPageToPartition(Consumer<PageReference> buffer, Page pageSplit) {
        PageReference pageReference = new PageReference(pageSplit, 1, this.onPageReleased);
        this.memoryManager.updateMemoryUsage(pageReference.getRetainedSizeInBytes());
        buffer.accept(pageReference);
    }

    @Override
    public ListenableFuture<Void> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }
}

