/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import io.trino.operator.window.matcher.ArrayView;
import io.trino.operator.window.matcher.IntMultimap;
import org.openjdk.jol.info.ClassLayout;

class Captures {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Captures.class).instanceSize();
    private final IntMultimap captures;
    private final IntMultimap labels;

    public Captures(int initialCapacity, int slotCount, int labelCount) {
        this.captures = new IntMultimap(initialCapacity, slotCount);
        this.labels = new IntMultimap(initialCapacity, labelCount);
    }

    public void save(int threadId, int value) {
        this.captures.add(threadId, value);
    }

    public void saveLabel(int threadId, int value) {
        this.labels.add(threadId, value);
    }

    public void copy(int parent, int child) {
        this.captures.copy(parent, child);
        this.labels.copy(parent, child);
    }

    public ArrayView getCaptures(int threadId) {
        return this.captures.getArrayView(threadId);
    }

    public ArrayView getLabels(int threadId) {
        return this.labels.getArrayView(threadId);
    }

    public void release(int threadId) {
        this.captures.release(threadId);
        this.labels.release(threadId);
    }

    public long getSizeInBytes() {
        return (long)INSTANCE_SIZE + this.captures.getSizeInBytes() + this.labels.getSizeInBytes();
    }
}

