/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.pattern;

import com.google.common.base.Preconditions;
import io.trino.operator.window.matcher.ArrayView;
import java.util.Objects;
import java.util.Set;

public class LogicalIndexNavigation {
    private final Set<Integer> labels;
    private final boolean last;
    private final boolean running;
    private final int logicalOffset;
    private final int physicalOffset;

    public LogicalIndexNavigation(Set<Integer> labels, boolean last, boolean running, int logicalOffset, int physicalOffset) {
        this.labels = Objects.requireNonNull(labels, "labels is null");
        this.last = last;
        this.running = running;
        Preconditions.checkArgument((logicalOffset >= 0 ? 1 : 0) != 0, (String)"logical offset must be >= 0, actual: ", (int)logicalOffset);
        this.logicalOffset = logicalOffset;
        this.physicalOffset = physicalOffset;
    }

    public Set<Integer> getLabels() {
        return this.labels;
    }

    public boolean isLast() {
        return this.last;
    }

    public int getLogicalOffset() {
        return this.logicalOffset;
    }

    public int getPhysicalOffset() {
        return this.physicalOffset;
    }

    public int resolvePosition(int currentRow, ArrayView matchedLabels, int searchStart, int searchEnd, int patternStart) {
        int relativePosition;
        Preconditions.checkArgument((currentRow >= patternStart && currentRow < patternStart + matchedLabels.length() ? 1 : 0) != 0, (Object)"current row is out of bounds of the match");
        if (this.last) {
            int start = this.running ? currentRow - patternStart : matchedLabels.length() - 1;
            relativePosition = this.findLastAndBackwards(start, matchedLabels);
        } else {
            relativePosition = this.findFirstAndForward(matchedLabels);
        }
        return this.adjustPosition(relativePosition, patternStart, searchStart, searchEnd);
    }

    private int findLastAndBackwards(int searchStart, ArrayView matchedLabels) {
        int position = searchStart + 1;
        int found = 0;
        while (found <= this.logicalOffset && position > 0) {
            if (!this.labels.isEmpty() && !this.labels.contains(matchedLabels.get(--position))) continue;
            ++found;
        }
        if (found == this.logicalOffset + 1) {
            return position;
        }
        return -1;
    }

    private int findFirstAndForward(ArrayView matchedLabels) {
        int position = -1;
        int found = 0;
        while (found <= this.logicalOffset && position < matchedLabels.length() - 1) {
            if (!this.labels.isEmpty() && !this.labels.contains(matchedLabels.get(++position))) continue;
            ++found;
        }
        if (found == this.logicalOffset + 1) {
            return position;
        }
        return -1;
    }

    private int adjustPosition(int relativePosition, int patternStart, int searchStart, int searchEnd) {
        if (relativePosition == -1) {
            return -1;
        }
        int start = relativePosition + patternStart;
        int target = start + this.physicalOffset;
        if (target < searchStart || target >= searchEnd) {
            return -1;
        }
        return target;
    }

    public LogicalIndexNavigation withoutLogicalOffset() {
        return this.withLogicalOffset(0);
    }

    public LogicalIndexNavigation withLogicalOffset(int logicalOffset) {
        return new LogicalIndexNavigation(this.labels, this.last, this.running, logicalOffset, this.physicalOffset);
    }

    public LogicalIndexNavigation withoutPhysicalOffset() {
        return this.withPhysicalOffset(0);
    }

    public LogicalIndexNavigation withPhysicalOffset(int physicalOffset) {
        return new LogicalIndexNavigation(this.labels, this.last, this.running, this.logicalOffset, physicalOffset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalIndexNavigation that = (LogicalIndexNavigation)o;
        return this.last == that.last && this.running == that.running && this.logicalOffset == that.logicalOffset && this.physicalOffset == that.physicalOffset && Objects.equals(this.labels, that.labels);
    }

    public int hashCode() {
        return Objects.hash(this.labels, this.last, this.running, this.logicalOffset, this.physicalOffset);
    }
}

