/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.FieldId;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.util.AstUtils;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

final class ScopeReferenceExtractor {
    private ScopeReferenceExtractor() {
    }

    public static boolean hasReferencesToScope(Node node, Analysis analysis, Scope scope) {
        return ScopeReferenceExtractor.getReferencesToScope(node, analysis, scope).findAny().isPresent();
    }

    public static Stream<Expression> getReferencesToScope(Node node, Analysis analysis, Scope scope) {
        Map<NodeRef<Expression>, ResolvedField> columnReferences = analysis.getColumnReferenceFields();
        return AstUtils.preOrder((Node)node).filter(Expression.class::isInstance).map(Expression.class::cast).filter(expression -> columnReferences.containsKey(NodeRef.of((Node)expression))).filter(expression -> ScopeReferenceExtractor.isReferenceToScope(expression, scope, columnReferences));
    }

    private static boolean isReferenceToScope(Expression node, Scope scope, Map<NodeRef<Expression>, ResolvedField> columnReferences) {
        ResolvedField field = columnReferences.get(NodeRef.of((Node)node));
        Objects.requireNonNull(field, () -> "No Field for " + node);
        return ScopeReferenceExtractor.isFieldFromScope(field.getFieldId(), scope);
    }

    public static boolean isFieldFromScope(FieldId field, Scope scope) {
        return Objects.equals(field.getRelationId(), scope.getRelationId());
    }
}

