/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.LogicalExpression;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class NormalizeOrExpressionRewriter {
    public static Expression normalizeOrExpression(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(), (Expression)expression);
    }

    private NormalizeOrExpressionRewriter() {
    }

    private static boolean isEqualityComparisonExpression(Expression expression) {
        return expression instanceof ComparisonExpression && ((ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL;
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        public Expression rewriteLogicalExpression(LogicalExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List terms = (List)node.getTerms().stream().map(expression -> treeRewriter.rewrite(expression, (Object)context)).collect(ImmutableList.toImmutableList());
            if (node.getOperator() == LogicalExpression.Operator.AND) {
                return ExpressionUtils.and(terms);
            }
            List comparisons = terms.stream().filter(x$0 -> NormalizeOrExpressionRewriter.isEqualityComparisonExpression(x$0)).map(ComparisonExpression.class::cast).collect(Collectors.groupingBy(ComparisonExpression::getLeft, LinkedHashMap::new, Collectors.mapping(ComparisonExpression::getRight, Collectors.toList()))).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> new InPredicate((Expression)entry.getKey(), (Expression)new InListExpression((List)entry.getValue()))).collect(Collectors.toList());
            Set expressionToSkip = (Set)comparisons.stream().map(InPredicate::getValue).collect(ImmutableSet.toImmutableSet());
            List others = terms.stream().filter(expression -> !NormalizeOrExpressionRewriter.isEqualityComparisonExpression(expression) || !expressionToSkip.contains(((ComparisonExpression)expression).getLeft())).collect(Collectors.toList());
            return ExpressionUtils.or((Collection<Expression>)ImmutableList.builder().addAll(others).addAll(comparisons).build());
        }
    }
}

