/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import java.util.List;

public class RemoveAggregationInSemiJoin
implements Rule<SemiJoinNode> {
    private static final Capture<AggregationNode> CHILD = Capture.newCapture();
    private static final Pattern<SemiJoinNode> PATTERN = Patterns.semiJoin().with(Patterns.SemiJoin.getFilteringSource().matching(Patterns.aggregation().capturedAs(CHILD).matching(AggregationNode::producesDistinctRows)));

    @Override
    public Pattern<SemiJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(SemiJoinNode semiJoinNode, Captures captures, Rule.Context context) {
        AggregationNode filteringSource = (AggregationNode)captures.get(CHILD);
        return Rule.Result.ofPlanNode(semiJoinNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)semiJoinNode.getSource(), (Object)((PlanNode)Iterables.getOnlyElement(filteringSource.getSources())))));
    }
}

