/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.Expression;
import java.util.List;

public class RemoveRedundantJoin
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join();

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode node, Captures captures, Rule.Context context) {
        if (this.canRemoveJoin(node.getType(), QueryCardinalityUtil.isAtMost(node.getLeft(), context.getLookup(), 0L), QueryCardinalityUtil.isAtMost(node.getRight(), context.getLookup(), 0L))) {
            return Rule.Result.ofPlanNode(new ValuesNode(context.getIdAllocator().getNextId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        return Rule.Result.empty();
    }

    private boolean canRemoveJoin(JoinNode.Type joinType, boolean isLeftSourceEmpty, boolean isRightSourceEmpty) {
        switch (joinType) {
            case INNER: {
                return isLeftSourceEmpty || isRightSourceEmpty;
            }
            case LEFT: {
                return isLeftSourceEmpty;
            }
            case RIGHT: {
                return isRightSourceEmpty;
            }
            case FULL: {
                return isLeftSourceEmpty && isRightSourceEmpty;
            }
        }
        return false;
    }
}

