/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations.joins;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.GroupReference;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.rule.PushProjectionThroughJoin;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.Expression;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JoinGraph {
    private final List<Expression> filters;
    private final List<PlanNode> nodes;
    private final Multimap<PlanNodeId, Edge> edges;
    private final PlanNodeId rootId;
    private final boolean containsCrossJoin;

    public static JoinGraph buildFrom(Metadata metadata, PlanNode plan, Lookup lookup, PlanNodeIdAllocator planNodeIdAllocator, Session session, TypeAnalyzer typeAnalyzer, TypeProvider types) {
        return plan.accept(new Builder(metadata, lookup, planNodeIdAllocator, session, typeAnalyzer, types), new Context());
    }

    public JoinGraph(PlanNode node) {
        this((List<PlanNode>)ImmutableList.of((Object)node), (Multimap<PlanNodeId, Edge>)ImmutableMultimap.of(), node.getId(), (List<Expression>)ImmutableList.of(), false);
    }

    public JoinGraph(List<PlanNode> nodes, Multimap<PlanNodeId, Edge> edges, PlanNodeId rootId, List<Expression> filters, boolean containsCrossJoin) {
        this.nodes = nodes;
        this.edges = edges;
        this.rootId = rootId;
        this.filters = filters;
        this.containsCrossJoin = containsCrossJoin;
    }

    public JoinGraph withFilter(Expression expression) {
        ImmutableList.Builder filters = ImmutableList.builder();
        filters.addAll(this.filters);
        filters.add((Object)expression);
        return new JoinGraph(this.nodes, this.edges, this.rootId, (List<Expression>)filters.build(), this.containsCrossJoin);
    }

    public List<Expression> getFilters() {
        return this.filters;
    }

    public PlanNodeId getRootId() {
        return this.rootId;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int size() {
        return this.nodes.size();
    }

    public PlanNode getNode(int index) {
        return this.nodes.get(index);
    }

    public List<PlanNode> getNodes() {
        return this.nodes;
    }

    public Collection<Edge> getEdges(PlanNode node) {
        return ImmutableList.copyOf((Collection)this.edges.get((Object)node.getId()));
    }

    public boolean isContainsCrossJoin() {
        return this.containsCrossJoin;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (PlanNode nodeFrom : this.nodes) {
            builder.append(nodeFrom.getId()).append(" = ").append(nodeFrom.toString()).append("\n");
        }
        for (PlanNode nodeFrom : this.nodes) {
            builder.append(nodeFrom.getId()).append(":");
            for (Edge nodeTo : this.edges.get((Object)nodeFrom.getId())) {
                builder.append(" ").append(nodeTo.getTargetNode().getId());
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private JoinGraph joinWith(JoinGraph other, List<JoinNode.EquiJoinClause> joinClauses, Context context, PlanNodeId newRoot, boolean containsCrossJoin) {
        for (PlanNode node : other.nodes) {
            Preconditions.checkState((!this.edges.containsKey((Object)node.getId()) ? 1 : 0) != 0, (String)"Node [%s] appeared in two JoinGraphs", (Object)node);
        }
        ImmutableList nodes = ImmutableList.builder().addAll(this.nodes).addAll(other.nodes).build();
        ImmutableMultimap.Builder edges = ImmutableMultimap.builder().putAll(this.edges).putAll(other.edges);
        ImmutableList joinedFilters = ImmutableList.builder().addAll(this.filters).addAll(other.filters).build();
        for (JoinNode.EquiJoinClause edge : joinClauses) {
            Symbol leftSymbol = edge.getLeft();
            Symbol rightSymbol = edge.getRight();
            Preconditions.checkState((boolean)context.containsSymbol(leftSymbol));
            Preconditions.checkState((boolean)context.containsSymbol(rightSymbol));
            PlanNode left = context.getSymbolSource(leftSymbol);
            PlanNode right = context.getSymbolSource(rightSymbol);
            edges.put((Object)left.getId(), (Object)new Edge(right, leftSymbol, rightSymbol));
            edges.put((Object)right.getId(), (Object)new Edge(left, rightSymbol, leftSymbol));
        }
        return new JoinGraph((List<PlanNode>)nodes, (Multimap<PlanNodeId, Edge>)edges.build(), newRoot, (List<Expression>)joinedFilters, this.containsCrossJoin || containsCrossJoin);
    }

    private static class Builder
    extends PlanVisitor<JoinGraph, Context> {
        private final Metadata metadata;
        private final Lookup lookup;
        private final PlanNodeIdAllocator planNodeIdAllocator;
        private final Session session;
        private final TypeAnalyzer typeAnalyzer;
        private final TypeProvider types;

        private Builder(Metadata metadata, Lookup lookup, PlanNodeIdAllocator planNodeIdAllocator, Session session, TypeAnalyzer typeAnalyzer, TypeProvider types) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.lookup = Objects.requireNonNull(lookup, "lookup cannot be null");
            this.planNodeIdAllocator = Objects.requireNonNull(planNodeIdAllocator, "planNodeIdAllocator is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
            this.types = Objects.requireNonNull(types, "types is null");
        }

        @Override
        protected JoinGraph visitPlan(PlanNode node, Context context) {
            for (Symbol symbol : node.getOutputSymbols()) {
                context.setSymbolSource(symbol, node);
            }
            return new JoinGraph(node);
        }

        @Override
        public JoinGraph visitFilter(FilterNode node, Context context) {
            JoinGraph graph = node.getSource().accept(this, context);
            return graph.withFilter(node.getPredicate());
        }

        @Override
        public JoinGraph visitJoin(JoinNode node, Context context) {
            if (node.getType() != JoinNode.Type.INNER) {
                return this.visitPlan((PlanNode)node, context);
            }
            JoinGraph left = node.getLeft().accept(this, context);
            JoinGraph right = node.getRight().accept(this, context);
            JoinGraph graph = left.joinWith(right, node.getCriteria(), context, node.getId(), node.isCrossJoin());
            if (node.getFilter().isPresent()) {
                return graph.withFilter(node.getFilter().get());
            }
            return graph;
        }

        @Override
        public JoinGraph visitProject(ProjectNode node, Context context) {
            Optional<PlanNode> rewrittenNode = PushProjectionThroughJoin.pushProjectionThroughJoin(this.metadata, node, this.lookup, this.planNodeIdAllocator, this.session, this.typeAnalyzer, this.types);
            if (rewrittenNode.isPresent()) {
                return rewrittenNode.get().accept(this, context);
            }
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        public JoinGraph visitGroupReference(GroupReference node, Context context) {
            PlanNode dereferenced = this.lookup.resolve(node);
            JoinGraph graph = dereferenced.accept(this, context);
            if (graph.nodes.size() == 1) {
                return this.replacementGraph((PlanNode)Iterables.getOnlyElement(graph.nodes), node, context);
            }
            return graph;
        }

        private JoinGraph replacementGraph(PlanNode oldNode, PlanNode newNode, Context context) {
            List symbols = (List)context.symbolSources.entrySet().stream().filter(entry -> entry.getValue() == oldNode).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
            symbols.forEach(symbol -> context.symbolSources.put((Symbol)symbol, newNode));
            return new JoinGraph(newNode);
        }
    }

    private static class Context {
        private final Map<Symbol, PlanNode> symbolSources = new HashMap<Symbol, PlanNode>();

        private Context() {
        }

        public void setSymbolSource(Symbol symbol, PlanNode node) {
            this.symbolSources.put(symbol, node);
        }

        public boolean containsSymbol(Symbol symbol) {
            return this.symbolSources.containsKey(symbol);
        }

        public PlanNode getSymbolSource(Symbol symbol) {
            Preconditions.checkState((boolean)this.containsSymbol(symbol));
            return this.symbolSources.get(symbol);
        }
    }

    public static class Edge {
        private final PlanNode targetNode;
        private final Symbol sourceSymbol;
        private final Symbol targetSymbol;

        public Edge(PlanNode targetNode, Symbol sourceSymbol, Symbol targetSymbol) {
            this.targetNode = Objects.requireNonNull(targetNode, "targetNode is null");
            this.sourceSymbol = Objects.requireNonNull(sourceSymbol, "sourceSymbol is null");
            this.targetSymbol = Objects.requireNonNull(targetSymbol, "targetSymbol is null");
        }

        public PlanNode getTargetNode() {
            return this.targetNode;
        }

        public Symbol getSourceSymbol() {
            return this.sourceSymbol;
        }

        public Symbol getTargetSymbol() {
            return this.targetSymbol;
        }
    }
}

