/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.tree.Expression;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UnnestNode
extends PlanNode {
    private final PlanNode source;
    private final List<Symbol> replicateSymbols;
    private final List<Mapping> mappings;
    private final Optional<Symbol> ordinalitySymbol;
    private final JoinNode.Type joinType;
    private final Optional<Expression> filter;

    @JsonCreator
    public UnnestNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="replicateSymbols") List<Symbol> replicateSymbols, @JsonProperty(value="mappings") List<Mapping> mappings, @JsonProperty(value="ordinalitySymbol") Optional<Symbol> ordinalitySymbol, @JsonProperty(value="joinType") JoinNode.Type joinType, @JsonProperty(value="filter") Optional<Expression> filter) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.replicateSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateSymbols, "replicateSymbols is null"));
        Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(replicateSymbols), (Object)"Source does not contain all replicateSymbols");
        Objects.requireNonNull(mappings, "mappings is null");
        Preconditions.checkArgument((!mappings.isEmpty() ? 1 : 0) != 0, (Object)"mappings is empty");
        this.mappings = ImmutableList.copyOf(mappings);
        this.ordinalitySymbol = Objects.requireNonNull(ordinalitySymbol, "ordinalitySymbol is null");
        this.joinType = Objects.requireNonNull(joinType, "joinType is null");
        this.filter = Objects.requireNonNull(filter, "filter is null");
        if (filter.isPresent()) {
            ImmutableSet outputs = ImmutableSet.copyOf(this.getOutputSymbols());
            Preconditions.checkArgument((boolean)outputs.containsAll(SymbolsExtractor.extractUnique(filter.get())), (Object)"Outputs do not contain all filter symbols");
        }
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder().addAll(this.replicateSymbols).addAll((Iterable)this.mappings.stream().map(Mapping::getOutputs).flatMap(Collection::stream).collect(ImmutableList.toImmutableList()));
        this.ordinalitySymbol.ifPresent(arg_0 -> ((ImmutableList.Builder)outputSymbolsBuilder).add(arg_0));
        return outputSymbolsBuilder.build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<Symbol> getReplicateSymbols() {
        return this.replicateSymbols;
    }

    @JsonProperty
    public List<Mapping> getMappings() {
        return this.mappings;
    }

    @JsonProperty
    public Optional<Symbol> getOrdinalitySymbol() {
        return this.ordinalitySymbol;
    }

    @JsonProperty
    public JoinNode.Type getJoinType() {
        return this.joinType;
    }

    @JsonProperty
    public Optional<Expression> getFilter() {
        return this.filter;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitUnnest(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new UnnestNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.replicateSymbols, this.mappings, this.ordinalitySymbol, this.joinType, this.filter);
    }

    public static class Mapping {
        private final Symbol input;
        private final List<Symbol> outputs;

        @JsonCreator
        public Mapping(@JsonProperty(value="input") Symbol input, @JsonProperty(value="outputs") List<Symbol> outputs) {
            this.input = Objects.requireNonNull(input, "input is null");
            Objects.requireNonNull(outputs, "outputs is null");
            this.outputs = ImmutableList.copyOf(outputs);
        }

        @JsonProperty
        public Symbol getInput() {
            return this.input;
        }

        @JsonProperty
        public List<Symbol> getOutputs() {
            return this.outputs;
        }
    }
}

