/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.AbstractBatchMessageContainer;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.SendCallback;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.protocol.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchMessageContainerImpl
extends AbstractBatchMessageContainer {
    protected MessageMetadata messageMetadata = new MessageMetadata();
    protected long lowestSequenceId = -1L;
    protected long highestSequenceId = -1L;
    protected ByteBuf batchedMessageMetadataAndPayload;
    protected List<MessageImpl<?>> messages = new ArrayList(this.maxMessagesNum);
    protected SendCallback previousCallback = null;
    protected SendCallback firstCallback;
    protected final ByteBufAllocator allocator;
    private static final int SHRINK_COOLING_OFF_PERIOD = 10;
    private int consecutiveShrinkTime = 0;
    private static final Logger log = LoggerFactory.getLogger(BatchMessageContainerImpl.class);

    public BatchMessageContainerImpl() {
        this(PulsarByteBufAllocator.DEFAULT);
    }

    @VisibleForTesting
    BatchMessageContainerImpl(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    public BatchMessageContainerImpl(ProducerImpl<?> producer) {
        this();
        this.setProducer(producer);
    }

    @Override
    public boolean add(MessageImpl<?> msg, SendCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] add message to batch, num messages in batch so far {}", new Object[]{this.topicName, this.producer.getProducerName(), this.numMessagesInBatch});
        }
        if (++this.numMessagesInBatch == 1) {
            try {
                this.messageMetadata.setSequenceId(msg.getSequenceId());
                this.lowestSequenceId = Commands.initBatchMessageMetadata((MessageMetadata)this.messageMetadata, (MessageMetadata)msg.getMessageBuilder());
                this.firstCallback = callback;
                this.batchedMessageMetadataAndPayload = this.allocator.buffer(Math.min(this.maxBatchSize, this.getMaxMessageSize()));
                this.updateAndReserveBatchAllocatedSize(this.batchedMessageMetadataAndPayload.capacity());
                if (msg.getMessageBuilder().hasTxnidMostBits() && this.currentTxnidMostBits == -1L) {
                    this.currentTxnidMostBits = msg.getMessageBuilder().getTxnidMostBits();
                }
                if (msg.getMessageBuilder().hasTxnidLeastBits() && this.currentTxnidLeastBits == -1L) {
                    this.currentTxnidLeastBits = msg.getMessageBuilder().getTxnidLeastBits();
                }
            }
            catch (Throwable e) {
                log.error("construct first message failed, exception is ", e);
                if (this.producer != null) {
                    this.producer.semaphoreRelease(this.getNumMessagesInBatch());
                    this.producer.client.getMemoryLimitController().releaseMemory(msg.getUncompressedSize() + this.batchAllocatedSizeBytes);
                }
                this.discard((Exception)((Object)new PulsarClientException(e)));
                return false;
            }
        }
        if (this.previousCallback != null) {
            this.previousCallback.addCallback(msg, callback);
        }
        this.previousCallback = callback;
        this.currentBatchSizeBytes += (long)msg.getDataBuffer().readableBytes();
        this.messages.add(msg);
        this.tryUpdateTimestamp();
        if (this.lowestSequenceId == -1L) {
            this.lowestSequenceId = msg.getSequenceId();
            this.messageMetadata.setSequenceId(this.lowestSequenceId);
        }
        this.highestSequenceId = msg.getSequenceId();
        if (this.producer != null) {
            ProducerImpl.LAST_SEQ_ID_PUSHED_UPDATER.getAndUpdate(this.producer, prev -> Math.max(prev, msg.getSequenceId()));
        }
        return this.isBatchFull();
    }

    protected ByteBuf getCompressedBatchMetadataAndPayload() {
        int batchWriteIndex = this.batchedMessageMetadataAndPayload.writerIndex();
        int batchReadIndex = this.batchedMessageMetadataAndPayload.readerIndex();
        int n = this.messages.size();
        for (int i = 0; i < n; ++i) {
            MessageImpl<?> msg = this.messages.get(i);
            msg.getDataBuffer().markReaderIndex();
            try {
                if (n == 1) {
                    this.batchedMessageMetadataAndPayload.writeBytes(msg.getDataBuffer());
                    continue;
                }
                this.batchedMessageMetadataAndPayload = Commands.serializeSingleMessageInBatchWithPayload((MessageMetadata)msg.getMessageBuilder(), (ByteBuf)msg.getDataBuffer(), (ByteBuf)this.batchedMessageMetadataAndPayload);
                continue;
            }
            catch (Throwable th) {
                this.batchedMessageMetadataAndPayload.writerIndex(batchWriteIndex);
                this.batchedMessageMetadataAndPayload.readerIndex(batchReadIndex);
                throw new RuntimeException(th);
            }
            finally {
                msg.getDataBuffer().resetReaderIndex();
            }
        }
        int uncompressedSize = this.batchedMessageMetadataAndPayload.readableBytes();
        ByteBuf compressedPayload = this.compressor.encode(this.batchedMessageMetadataAndPayload);
        this.batchedMessageMetadataAndPayload.release();
        if (this.compressionType != CompressionType.NONE) {
            this.messageMetadata.setCompression(this.compressionType);
            this.messageMetadata.setUncompressedSize(uncompressedSize);
        }
        this.updateMaxBatchSize(uncompressedSize);
        this.maxMessagesNum = Math.max(this.maxMessagesNum, this.numMessagesInBatch);
        return compressedPayload;
    }

    void updateMaxBatchSize(int uncompressedSize) {
        if (uncompressedSize > this.maxBatchSize) {
            this.maxBatchSize = uncompressedSize;
            this.consecutiveShrinkTime = 0;
        } else {
            int shrank = this.maxBatchSize - (this.maxBatchSize >> 2);
            if (uncompressedSize <= shrank) {
                if (this.consecutiveShrinkTime <= 10) {
                    ++this.consecutiveShrinkTime;
                } else {
                    this.maxBatchSize = shrank;
                    this.consecutiveShrinkTime = 0;
                }
            } else {
                this.consecutiveShrinkTime = 0;
            }
        }
    }

    public void clear() {
        this.clearTimestamp();
        this.messages = new ArrayList(this.maxMessagesNum);
        this.firstCallback = null;
        this.previousCallback = null;
        this.messageMetadata.clear();
        this.numMessagesInBatch = 0;
        this.currentBatchSizeBytes = 0L;
        this.lowestSequenceId = -1L;
        this.highestSequenceId = -1L;
        this.batchedMessageMetadataAndPayload = null;
        this.currentTxnidMostBits = -1L;
        this.currentTxnidLeastBits = -1L;
        this.batchAllocatedSizeBytes = 0;
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public void discard(Exception ex) {
        try {
            if (this.firstCallback != null) {
                this.firstCallback.sendComplete(ex);
            }
            if (this.batchedMessageMetadataAndPayload != null) {
                ReferenceCountUtil.safeRelease((Object)this.batchedMessageMetadataAndPayload);
                this.batchedMessageMetadataAndPayload = null;
            }
        }
        catch (Throwable t) {
            log.warn("[{}] [{}] Got exception while completing the callback for msg {}:", new Object[]{this.topicName, this.producer.getProducerName(), this.lowestSequenceId, t});
        }
        this.clear();
    }

    public boolean isMultiBatches() {
        return false;
    }

    @Override
    public ProducerImpl.OpSendMsg createOpSendMsg() throws IOException {
        if (this.messages.size() == 1) {
            this.messageMetadata.clear();
            this.messageMetadata.copyFrom(this.messages.get(0).getMessageBuilder());
            ByteBuf encryptedPayload = this.producer.encryptMessage(this.messageMetadata, this.getCompressedBatchMetadataAndPayload());
            this.updateAndReserveBatchAllocatedSize(encryptedPayload.capacity());
            ByteBufPair cmd = this.producer.sendMessage(this.producer.producerId, this.messageMetadata.getSequenceId(), 1, null, this.messageMetadata, encryptedPayload);
            ProducerImpl.OpSendMsg op = ProducerImpl.OpSendMsg.create(this.messages, cmd, this.messageMetadata.getSequenceId(), this.firstCallback, this.batchAllocatedSizeBytes);
            op.setNumMessagesInBatch(1);
            op.setBatchSizeByte(encryptedPayload.readableBytes());
            if (op.getMessageHeaderAndPayloadSize() > this.getMaxMessageSize()) {
                cmd.release();
                this.producer.semaphoreRelease(1);
                this.producer.client.getMemoryLimitController().releaseMemory(this.messages.get(0).getUncompressedSize() + this.batchAllocatedSizeBytes);
                this.discard((Exception)new PulsarClientException.InvalidMessageException("Message size is bigger than " + this.getMaxMessageSize() + " bytes"));
                return null;
            }
            this.lowestSequenceId = -1L;
            return op;
        }
        ByteBuf encryptedPayload = this.producer.encryptMessage(this.messageMetadata, this.getCompressedBatchMetadataAndPayload());
        this.updateAndReserveBatchAllocatedSize(encryptedPayload.capacity());
        if (encryptedPayload.readableBytes() > this.getMaxMessageSize()) {
            encryptedPayload.release();
            this.producer.semaphoreRelease(this.messages.size());
            this.messages.forEach(msg -> this.producer.client.getMemoryLimitController().releaseMemory(msg.getUncompressedSize()));
            this.producer.client.getMemoryLimitController().releaseMemory(this.batchAllocatedSizeBytes);
            this.discard((Exception)new PulsarClientException.InvalidMessageException("Message size " + encryptedPayload.readableBytes() + " is bigger than " + this.getMaxMessageSize() + " bytes"));
            return null;
        }
        this.messageMetadata.setNumMessagesInBatch(this.numMessagesInBatch);
        this.messageMetadata.setSequenceId(this.lowestSequenceId);
        this.messageMetadata.setHighestSequenceId(this.highestSequenceId);
        if (this.currentTxnidMostBits != -1L) {
            this.messageMetadata.setTxnidMostBits(this.currentTxnidMostBits);
        }
        if (this.currentTxnidLeastBits != -1L) {
            this.messageMetadata.setTxnidLeastBits(this.currentTxnidLeastBits);
        }
        ByteBufPair cmd = this.producer.sendMessage(this.producer.producerId, this.messageMetadata.getSequenceId(), this.messageMetadata.getHighestSequenceId(), this.numMessagesInBatch, this.messageMetadata, encryptedPayload);
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] Build batch msg seq:{}, highest-seq:{}, numMessagesInBatch: {}, uncompressedSize: {}, payloadSize: {}", new Object[]{this.topicName, this.producer.getProducerName(), this.messageMetadata.getSequenceId(), this.messageMetadata.getNumMessagesInBatch(), this.messageMetadata.getHighestSequenceId(), this.messageMetadata.getUncompressedSize(), encryptedPayload.readableBytes()});
        }
        ProducerImpl.OpSendMsg op = ProducerImpl.OpSendMsg.create(this.messages, cmd, this.messageMetadata.getSequenceId(), this.messageMetadata.getHighestSequenceId(), this.firstCallback, this.batchAllocatedSizeBytes);
        op.setNumMessagesInBatch(this.numMessagesInBatch);
        op.setBatchSizeByte(this.currentBatchSizeBytes);
        this.lowestSequenceId = -1L;
        return op;
    }

    @Override
    public void resetPayloadAfterFailedPublishing() {
        if (this.batchedMessageMetadataAndPayload != null) {
            this.batchedMessageMetadataAndPayload.readerIndex(0);
            this.batchedMessageMetadataAndPayload.writerIndex(0);
        }
    }

    protected void updateAndReserveBatchAllocatedSize(int updatedSizeBytes) {
        int delta = updatedSizeBytes - this.batchAllocatedSizeBytes;
        this.batchAllocatedSizeBytes = updatedSizeBytes;
        if (this.producer != null) {
            if (delta > 0) {
                this.producer.client.getMemoryLimitController().forceReserveMemory(delta);
            } else if (delta < 0) {
                this.producer.client.getMemoryLimitController().releaseMemory(-delta);
            }
        }
    }

    @Override
    public boolean hasSameSchema(MessageImpl<?> msg) {
        if (this.numMessagesInBatch == 0) {
            return true;
        }
        if (!this.messageMetadata.hasSchemaVersion()) {
            return msg.getSchemaVersion() == null;
        }
        return Arrays.equals(msg.getSchemaVersion(), this.messageMetadata.getSchemaVersion());
    }

    @Generated
    public long getLowestSequenceId() {
        return this.lowestSequenceId;
    }

    @Generated
    public void setLowestSequenceId(long lowestSequenceId) {
        this.lowestSequenceId = lowestSequenceId;
    }

    @Generated
    public long getHighestSequenceId() {
        return this.highestSequenceId;
    }

    @Generated
    public void setHighestSequenceId(long highestSequenceId) {
        this.highestSequenceId = highestSequenceId;
    }
}

