/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto.decoder.primitive;

import io.netty.buffer.ByteBuf;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.FieldValueProviders;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.sql.presto.PulsarFieldValueProviders;
import org.apache.pulsar.sql.presto.PulsarRowDecoder;

public class PulsarPrimitiveRowDecoder
implements PulsarRowDecoder {
    private final DecoderColumnHandle columnHandle;
    private AbstractSchema schema;

    public PulsarPrimitiveRowDecoder(AbstractSchema schema, DecoderColumnHandle column) {
        this.columnHandle = column;
        this.schema = schema;
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(ByteBuf byteBuf) {
        if (this.columnHandle == null) {
            return Optional.empty();
        }
        Object value = this.schema.decode(byteBuf);
        HashMap<DecoderColumnHandle, FieldValueProvider> primitiveColumn = new HashMap<DecoderColumnHandle, FieldValueProvider>();
        if (value == null) {
            primitiveColumn.put(this.columnHandle, FieldValueProviders.nullValueProvider());
        } else {
            Type type = this.columnHandle.getType();
            if (type instanceof BooleanType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.booleanValueProvider((boolean)((Boolean)value)));
            } else if (type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.longValueProvider((long)Long.parseLong(value.toString())));
            } else if (type instanceof DoubleType) {
                primitiveColumn.put(this.columnHandle, PulsarFieldValueProviders.doubleValueProvider(Double.parseDouble(value.toString())));
            } else if (type instanceof RealType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.longValueProvider((long)Float.floatToIntBits(Float.parseFloat(value.toString()))));
            } else if (type instanceof VarbinaryType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.bytesValueProvider((byte[])((byte[])value)));
            } else if (type instanceof VarcharType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.bytesValueProvider((byte[])value.toString().getBytes()));
            } else if (type instanceof DateType) {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.longValueProvider((long)((Date)value).getTime()));
            } else if (type instanceof TimeType) {
                long millis = ((Time)value).getTime();
                long picos = millis * 1000000000L;
                primitiveColumn.put(this.columnHandle, FieldValueProviders.longValueProvider((long)picos));
            } else if (type instanceof TimestampType) {
                long millis = ((Timestamp)value).getTime();
                long micros = millis * 1000L;
                primitiveColumn.put(this.columnHandle, FieldValueProviders.longValueProvider((long)micros));
            } else {
                primitiveColumn.put(this.columnHandle, FieldValueProviders.bytesValueProvider((byte[])value.toString().getBytes()));
            }
        }
        return Optional.of(primitiveColumn);
    }
}

