/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.control;

import com.google.common.base.MoreObjects;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.instruction.LabelNode;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CaseStatement
implements Comparable<CaseStatement> {
    private final int key;
    private final BytecodeNode body;
    private final LabelNode label;

    CaseStatement(int key, BytecodeNode body, LabelNode label) {
        this.key = key;
        this.body = Objects.requireNonNull(body, "body is null");
        this.label = Objects.requireNonNull(label, "label is null");
    }

    public int getKey() {
        return this.key;
    }

    public BytecodeNode getBody() {
        return this.body;
    }

    public LabelNode getLabel() {
        return this.label;
    }

    @Override
    public int compareTo(CaseStatement o) {
        return Integer.compare(this.key, o.key);
    }

    public int hashCode() {
        return this.key;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CaseStatement other = (CaseStatement)obj;
        return Objects.equals(this.key, other.key);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", this.key).toString();
    }
}

