/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode.debug;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.BytecodeVisitor;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.debug.DebugNode;
import io.airlift.bytecode.instruction.LabelNode;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class LineNumberNode
implements DebugNode {
    private final int lineNumber;
    private final LabelNode label = new LabelNode();

    public LineNumberNode(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
        if (generationContext.updateLineNumber(this.lineNumber)) {
            this.label.accept(visitor, generationContext);
            visitor.visitLineNumber(this.lineNumber, this.label.getLabel());
        }
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("line", this.lineNumber).toString();
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
        return visitor.visitLineNumber(parent, this);
    }
}

