/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.function.Function;
import org.openjdk.jol.info.ClassLayout;

public final class SplitWeight {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SplitWeight.class).instanceSize();
    private static final long UNIT_VALUE = 100L;
    private static final int UNIT_SCALE = 2;
    private static final SplitWeight STANDARD_WEIGHT = new SplitWeight(100L);
    private final long value;

    private SplitWeight(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("value must be > 0, found: " + value);
        }
        this.value = value;
    }

    @JsonValue
    public long getRawValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SplitWeight)) {
            return false;
        }
        return this.value == ((SplitWeight)other).value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public String toString() {
        if (this.value == 100L) {
            return "1";
        }
        return BigDecimal.valueOf(this.value, -2).stripTrailingZeros().toPlainString();
    }

    @JsonCreator
    public static SplitWeight fromRawValue(long value) {
        return value == 100L ? STANDARD_WEIGHT : new SplitWeight(value);
    }

    public static SplitWeight fromProportion(double weight) {
        if (weight <= 0.0 || !Double.isFinite(weight)) {
            throw new IllegalArgumentException("Invalid weight: " + weight);
        }
        return SplitWeight.fromRawValue((long)Math.ceil(weight * 100.0));
    }

    public static SplitWeight standard() {
        return STANDARD_WEIGHT;
    }

    public static long rawValueForStandardSplitCount(int splitCount) {
        if (splitCount < 0) {
            throw new IllegalArgumentException("splitCount must be >= 0, found: " + splitCount);
        }
        return Math.multiplyExact((long)splitCount, 100L);
    }

    public static <T> long rawValueSum(Collection<T> collection, Function<T, SplitWeight> getter) {
        long sum = 0L;
        for (T item : collection) {
            long value = getter.apply(item).getRawValue();
            sum = Math.addExact(sum, value);
        }
        return sum;
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

