/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.Int96ArrayBlock;
import io.trino.spi.block.Int96ArrayBlockBuilder;

public class Int96ArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "INT96_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        if (!block.mayHaveNull()) {
            sliceOutput.writeBytes(this.getHighSlice(block));
            sliceOutput.writeBytes(this.getLowSlice(block));
        } else {
            long[] high = new long[positionCount];
            int[] low = new int[positionCount];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                high[nonNullPositionCount] = block.getLong(i, 0);
                low[nonNullPositionCount] = block.getInt(i, 8);
                if (block.isNull(i)) continue;
                ++nonNullPositionCount;
            }
            sliceOutput.writeInt(nonNullPositionCount);
            sliceOutput.writeBytes(Slices.wrappedLongArray((long[])high, (int)0, (int)nonNullPositionCount));
            sliceOutput.writeBytes(Slices.wrappedIntArray((int[])low, (int)0, (int)nonNullPositionCount));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int i;
        int positionCount = sliceInput.readInt();
        byte[] valueIsNullPacked = EncoderUtil.retrieveNullBits(sliceInput, positionCount);
        long[] high = new long[positionCount];
        int[] low = new int[positionCount];
        if (valueIsNullPacked == null) {
            sliceInput.readBytes(Slices.wrappedLongArray((long[])high));
            sliceInput.readBytes(Slices.wrappedIntArray((int[])low));
            return new Int96ArrayBlock(0, positionCount, null, high, low);
        }
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(valueIsNullPacked, positionCount);
        int nonNullPositionCount = sliceInput.readInt();
        sliceInput.readBytes(Slices.wrappedLongArray((long[])high, (int)0, (int)nonNullPositionCount));
        sliceInput.readBytes(Slices.wrappedIntArray((int[])low, (int)0, (int)nonNullPositionCount));
        int position = nonNullPositionCount - 1;
        for (i = positionCount - 1; i >= (positionCount & 0xFFFFFFF8) && position >= 0; --i) {
            high[i] = high[position];
            low[i] = low[position];
            if (valueIsNull[i]) continue;
            --position;
        }
        for (i = (positionCount & 0xFFFFFFF8) - 8; i >= 0 && position >= 0; i -= 8) {
            byte packed = valueIsNullPacked[i >> 3];
            if (packed == 0) {
                System.arraycopy(high, position - 7, high, i, 8);
                System.arraycopy(low, position - 7, low, i, 8);
                position -= 8;
                continue;
            }
            if (packed == -1) continue;
            for (int j = i + 7; j >= i && position >= 0; --j) {
                high[j] = high[position];
                low[j] = low[position];
                if (valueIsNull[j]) continue;
                --position;
            }
        }
        return new Int96ArrayBlock(0, positionCount, valueIsNull, high, low);
    }

    private Slice getHighSlice(Block block) {
        if (block instanceof Int96ArrayBlock) {
            return ((Int96ArrayBlock)block).getHighSlice();
        }
        if (block instanceof Int96ArrayBlockBuilder) {
            return ((Int96ArrayBlockBuilder)block).getHighSlice();
        }
        throw new IllegalArgumentException("Unexpected block type " + block.getClass().getSimpleName());
    }

    private Slice getLowSlice(Block block) {
        if (block instanceof Int96ArrayBlock) {
            return ((Int96ArrayBlock)block).getLowSlice();
        }
        if (block instanceof Int96ArrayBlockBuilder) {
            return ((Int96ArrayBlockBuilder)block).getLowSlice();
        }
        throw new IllegalArgumentException("Unexpected block type " + block.getClass().getSimpleName());
    }
}

