/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class SplitStatistics {
    private final Duration cpuTime;
    private final Duration wallTime;
    private final Duration queuedTime;
    private final Duration completedReadTime;
    private final long completedPositions;
    private final long completedDataSizeBytes;
    private final Optional<Duration> timeToFirstByte;
    private final Optional<Duration> timeToLastByte;

    @JsonCreator
    public SplitStatistics(Duration cpuTime, Duration wallTime, Duration queuedTime, Duration completedReadTime, long completedPositions, long completedDataSizeBytes, Optional<Duration> timeToFirstByte, Optional<Duration> timeToLastByte) {
        this.cpuTime = Objects.requireNonNull(cpuTime, "cpuTime is null");
        this.wallTime = Objects.requireNonNull(wallTime, "wallTime is null");
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.completedReadTime = Objects.requireNonNull(completedReadTime, "completedReadTime is null");
        this.completedPositions = completedPositions;
        this.completedDataSizeBytes = completedDataSizeBytes;
        this.timeToFirstByte = Objects.requireNonNull(timeToFirstByte, "timeToFirstByte is null");
        this.timeToLastByte = Objects.requireNonNull(timeToLastByte, "timeToLastByte is null");
    }

    @JsonProperty
    public Duration getCpuTime() {
        return this.cpuTime;
    }

    @JsonProperty
    public Duration getWallTime() {
        return this.wallTime;
    }

    @JsonProperty
    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    public Duration getCompletedReadTime() {
        return this.completedReadTime;
    }

    @JsonProperty
    public long getCompletedPositions() {
        return this.completedPositions;
    }

    @JsonProperty
    public long getCompletedDataSizeBytes() {
        return this.completedDataSizeBytes;
    }

    @JsonProperty
    @Deprecated
    public Optional<Duration> getTimeToFirstByte() {
        return this.timeToFirstByte;
    }

    @JsonProperty
    @Deprecated
    public Optional<Duration> getTimeToLastByte() {
        return this.timeToLastByte;
    }
}

