/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Query;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SubqueryExpression
extends Expression {
    private final Query query;

    public SubqueryExpression(Query query) {
        this(Optional.empty(), query);
    }

    public SubqueryExpression(NodeLocation location, Query query) {
        this(Optional.of(location), query);
    }

    private SubqueryExpression(Optional<NodeLocation> location, Query query) {
        super(location);
        this.query = query;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSubqueryExpression(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.query);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubqueryExpression that = (SubqueryExpression)o;
        return Objects.equals(this.query, that.query);
    }

    @Override
    public int hashCode() {
        return this.query.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return SubqueryExpression.sameClass(this, other);
    }
}

