/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient.utils;

import java.util.Objects;
import java.util.function.Function;

public class FixedColumnLengthTableMaker {
    public char bottomBorder = (char)61;
    public String decimalFormatter = null;
    public int elementLength = 10;
    public String leftBorder = "||";
    public int leftPadding = 0;
    public String rightBorder = "||";
    public int rightPadding = 1;
    public String separator = "|";
    public char topBorder = (char)61;
    public Function<Integer, Integer> lengthFunction = null;

    private void addHorizontalBorder(int length, StringBuilder builder, char borderChar) {
        for (int i = 0; i < length; ++i) {
            builder.append(borderChar);
        }
    }

    private void addSpace(int amount, StringBuilder builder) {
        for (int i = 0; i < amount; ++i) {
            builder.append(' ');
        }
    }

    private int lengthFor(int column) {
        return this.lengthFunction == null ? this.elementLength : this.lengthFunction.apply(column);
    }

    public String make(Object[][] rows) {
        int i;
        StringBuilder builder = new StringBuilder();
        int numColumns = 0;
        for (Object[] row : rows) {
            numColumns = Math.max(numColumns, row.length);
        }
        int totalLength = numColumns * (this.leftPadding + this.rightPadding + this.separator.length()) - this.separator.length() + this.leftBorder.length() + this.rightBorder.length();
        for (i = 0; i < numColumns; ++i) {
            totalLength += this.lengthFor(i);
        }
        this.addHorizontalBorder(totalLength, builder, this.topBorder);
        builder.append('\n');
        for (Object[] row : rows) {
            i = 0;
            builder.append(this.leftBorder);
            for (Object element : row) {
                this.addSpace(this.leftPadding, builder);
                String elementString = (element instanceof Float || element instanceof Double) && this.decimalFormatter != null ? String.format(this.decimalFormatter, element) : Objects.toString(element, "");
                if (elementString.length() > this.lengthFor(i)) {
                    elementString = elementString.substring(0, this.lengthFor(i));
                }
                builder.append(elementString);
                this.addSpace(this.lengthFor(i) - elementString.length() + this.rightPadding, builder);
                if (i != numColumns - 1) {
                    builder.append(this.separator);
                }
                ++i;
            }
            while (i < numColumns) {
                this.addSpace(this.leftPadding + this.rightPadding + this.lengthFor(i), builder);
                if (i != numColumns - 1) {
                    builder.append(this.separator);
                }
                ++i;
            }
            builder.append(this.rightBorder);
            builder.append('\n');
        }
        this.addHorizontalBorder(totalLength, builder, this.bottomBorder);
        return builder.toString();
    }
}

