/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.opentelemetry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.grpc.CallbackMetricInstrument;
import io.grpc.DoubleCounterMetricInstrument;
import io.grpc.DoubleHistogramMetricInstrument;
import io.grpc.LongCounterMetricInstrument;
import io.grpc.LongGaugeMetricInstrument;
import io.grpc.LongHistogramMetricInstrument;
import io.grpc.MetricInstrument;
import io.grpc.MetricSink;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.DoubleCounter;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

final class OpenTelemetryMetricSink
implements MetricSink {
    private static final Logger logger = Logger.getLogger(OpenTelemetryMetricSink.class.getName());
    private final Object lock = new Object();
    private final Meter openTelemetryMeter;
    private final Map<String, Boolean> enableMetrics;
    private final boolean disableDefaultMetrics;
    private final Set<String> optionalLabels;
    private volatile List<MeasuresData> measures = new ArrayList<MeasuresData>();

    OpenTelemetryMetricSink(Meter meter, Map<String, Boolean> enableMetrics, boolean disableDefaultMetrics, List<String> optionalLabels) {
        this.openTelemetryMeter = (Meter)Preconditions.checkNotNull((Object)meter, (Object)"meter");
        this.enableMetrics = ImmutableMap.copyOf(enableMetrics);
        this.disableDefaultMetrics = disableDefaultMetrics;
        this.optionalLabels = ImmutableSet.copyOf(optionalLabels);
    }

    public Map<String, Boolean> getEnabledMetrics() {
        return this.enableMetrics;
    }

    public Set<String> getOptionalLabels() {
        return this.optionalLabels;
    }

    public int getMeasuresSize() {
        return this.measures.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<MeasuresData> getMeasures() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableList(this.measures);
        }
    }

    public void addDoubleCounter(DoubleCounterMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MeasuresData instrumentData = this.measures.get(metricInstrument.getIndex());
        if (instrumentData == null) {
            return;
        }
        Attributes attributes = this.createAttributes(metricInstrument.getRequiredLabelKeys(), metricInstrument.getOptionalLabelKeys(), requiredLabelValues, optionalLabelValues, instrumentData.getOptionalLabelsBitSet());
        DoubleCounter counter = (DoubleCounter)instrumentData.getMeasure();
        counter.add(value, attributes);
    }

    public void addLongCounter(LongCounterMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MeasuresData instrumentData = this.measures.get(metricInstrument.getIndex());
        if (instrumentData == null) {
            return;
        }
        Attributes attributes = this.createAttributes(metricInstrument.getRequiredLabelKeys(), metricInstrument.getOptionalLabelKeys(), requiredLabelValues, optionalLabelValues, instrumentData.getOptionalLabelsBitSet());
        LongCounter counter = (LongCounter)instrumentData.getMeasure();
        counter.add(value, attributes);
    }

    public void recordDoubleHistogram(DoubleHistogramMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MeasuresData instrumentData = this.measures.get(metricInstrument.getIndex());
        if (instrumentData == null) {
            return;
        }
        Attributes attributes = this.createAttributes(metricInstrument.getRequiredLabelKeys(), metricInstrument.getOptionalLabelKeys(), requiredLabelValues, optionalLabelValues, instrumentData.getOptionalLabelsBitSet());
        DoubleHistogram histogram = (DoubleHistogram)instrumentData.getMeasure();
        histogram.record(value, attributes);
    }

    public void recordLongHistogram(LongHistogramMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MeasuresData instrumentData = this.measures.get(metricInstrument.getIndex());
        if (instrumentData == null) {
            return;
        }
        Attributes attributes = this.createAttributes(metricInstrument.getRequiredLabelKeys(), metricInstrument.getOptionalLabelKeys(), requiredLabelValues, optionalLabelValues, instrumentData.getOptionalLabelsBitSet());
        LongHistogram histogram = (LongHistogram)instrumentData.getMeasure();
        histogram.record(value, attributes);
    }

    public void recordLongGauge(LongGaugeMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MeasuresData instrumentData = this.measures.get(metricInstrument.getIndex());
        if (instrumentData == null) {
            return;
        }
        Attributes attributes = this.createAttributes(metricInstrument.getRequiredLabelKeys(), metricInstrument.getOptionalLabelKeys(), requiredLabelValues, optionalLabelValues, instrumentData.getOptionalLabelsBitSet());
        ObservableLongMeasurement gauge = (ObservableLongMeasurement)instrumentData.getMeasure();
        gauge.record(value, attributes);
    }

    public MetricSink.Registration registerBatchCallback(Runnable callback, CallbackMetricInstrument ... metricInstruments) {
        ArrayList<ObservableMeasurement> measurements = new ArrayList<ObservableMeasurement>(metricInstruments.length);
        for (CallbackMetricInstrument metricInstrument : metricInstruments) {
            MeasuresData instrumentData = this.measures.get(metricInstrument.getIndex());
            if (instrumentData == null) continue;
            if (!(instrumentData.getMeasure() instanceof ObservableMeasurement)) {
                logger.log(Level.FINE, "Unsupported metric instrument type : {0} {1}", new Object[]{metricInstrument, instrumentData.getMeasure().getClass()});
                continue;
            }
            measurements.add((ObservableMeasurement)instrumentData.getMeasure());
        }
        if (measurements.isEmpty()) {
            return () -> {};
        }
        ObservableMeasurement first = (ObservableMeasurement)measurements.get(0);
        measurements.remove(0);
        BatchCallback closeable = this.openTelemetryMeter.batchCallback(callback, first, measurements.toArray(new ObservableMeasurement[0]));
        return () -> ((BatchCallback)closeable).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMeasures(List<MetricInstrument> instruments) {
        Object object = this.lock;
        synchronized (object) {
            if (this.measures.size() >= instruments.size()) {
                return;
            }
            ArrayList<MeasuresData> newMeasures = new ArrayList<MeasuresData>(instruments.size());
            newMeasures.addAll(this.measures);
            for (int i = this.measures.size(); i < instruments.size(); ++i) {
                DoubleCounter openTelemetryMeasure;
                MetricInstrument instrument = instruments.get(i);
                if (!this.shouldEnableMetric(instrument)) {
                    newMeasures.add(null);
                    continue;
                }
                BitSet bitSet = new BitSet(instrument.getOptionalLabelKeys().size());
                if (!this.optionalLabels.isEmpty()) {
                    List labels = instrument.getOptionalLabelKeys();
                    for (int j = 0; j < labels.size(); ++j) {
                        if (!this.optionalLabels.contains(labels.get(j))) continue;
                        bitSet.set(j);
                    }
                }
                int index = instrument.getIndex();
                String name = instrument.getName();
                String unit = instrument.getUnit();
                String description = instrument.getDescription();
                if (instrument instanceof DoubleCounterMetricInstrument) {
                    openTelemetryMeasure = this.openTelemetryMeter.counterBuilder(name).setUnit(unit).setDescription(description).ofDoubles().build();
                } else if (instrument instanceof LongCounterMetricInstrument) {
                    openTelemetryMeasure = this.openTelemetryMeter.counterBuilder(name).setUnit(unit).setDescription(description).build();
                } else if (instrument instanceof DoubleHistogramMetricInstrument) {
                    openTelemetryMeasure = this.openTelemetryMeter.histogramBuilder(name).setUnit(unit).setDescription(description).build();
                } else if (instrument instanceof LongHistogramMetricInstrument) {
                    openTelemetryMeasure = this.openTelemetryMeter.histogramBuilder(name).setUnit(unit).setDescription(description).ofLongs().build();
                } else if (instrument instanceof LongGaugeMetricInstrument) {
                    openTelemetryMeasure = this.openTelemetryMeter.gaugeBuilder(name).setUnit(unit).setDescription(description).ofLongs().buildObserver();
                } else {
                    logger.log(Level.FINE, "Unsupported metric instrument type : {0}", instrument);
                    openTelemetryMeasure = null;
                }
                newMeasures.add(index, new MeasuresData(bitSet, openTelemetryMeasure));
            }
            this.measures = newMeasures;
        }
    }

    private boolean shouldEnableMetric(MetricInstrument instrument) {
        Boolean explicitlyEnabled = this.enableMetrics.get(instrument.getName());
        if (explicitlyEnabled != null) {
            return explicitlyEnabled;
        }
        return instrument.isEnableByDefault() && !this.disableDefaultMetrics;
    }

    private Attributes createAttributes(List<String> requiredLabelKeys, List<String> optionalLabelKeys, List<String> requiredLabelValues, List<String> optionalLabelValues, BitSet bitSet) {
        int i;
        AttributesBuilder builder = Attributes.builder();
        for (i = 0; i < requiredLabelKeys.size(); ++i) {
            builder.put(requiredLabelKeys.get(i), requiredLabelValues.get(i));
        }
        i = bitSet.nextSetBit(0);
        while (i >= 0 && i != Integer.MAX_VALUE) {
            builder.put(optionalLabelKeys.get(i), optionalLabelValues.get(i));
            i = bitSet.nextSetBit(i + 1);
        }
        return builder.build();
    }

    static final class MeasuresData {
        final BitSet optionalLabelsIndices;
        final Object measure;

        MeasuresData(BitSet optionalLabelsIndices, Object measure) {
            this.optionalLabelsIndices = optionalLabelsIndices;
            this.measure = measure;
        }

        public BitSet getOptionalLabelsBitSet() {
            return this.optionalLabelsIndices;
        }

        public Object getMeasure() {
            return this.measure;
        }
    }
}

