/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.EventLoopGroup;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.metrics.InstrumentProvider;
import org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.common.api.proto.CommandAuthChallenge;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.util.netty.NettyChannelUtil;
import org.apache.pulsar.proxy.server.ProxyConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyClientCnx
extends ClientCnx {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxyClientCnx.class);
    private final boolean forwardClientAuthData;
    private final String clientAuthMethod;
    private final String clientAuthRole;
    private final ProxyConnection proxyConnection;

    public ProxyClientCnx(ClientConfigurationData conf, EventLoopGroup eventLoopGroup, String clientAuthRole, String clientAuthMethod, int protocolVersion, boolean forwardClientAuthData, ProxyConnection proxyConnection) {
        super(InstrumentProvider.NOOP, conf, eventLoopGroup, protocolVersion);
        this.clientAuthRole = clientAuthRole;
        this.clientAuthMethod = clientAuthMethod;
        this.forwardClientAuthData = forwardClientAuthData;
        this.proxyConnection = proxyConnection;
    }

    protected ByteBuf newConnectCommand() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("New Connection opened via ProxyClientCnx with params clientAuthRole = {}, clientAuthData = {}, clientAuthMethod = {}", new Object[]{this.clientAuthRole, this.proxyConnection.getClientAuthData(), this.clientAuthMethod});
        }
        AuthData clientAuthData = null;
        if (this.forwardClientAuthData) {
            clientAuthData = this.proxyConnection.getClientAuthData();
        }
        this.authenticationDataProvider = this.authentication.getAuthData(this.remoteHostName);
        AuthData authData = this.authenticationDataProvider.authenticate(AuthData.INIT_AUTH_DATA);
        return Commands.newConnect((String)this.authentication.getAuthMethodName(), (AuthData)authData, (int)this.protocolVersion, (String)this.proxyConnection.clientVersion, (String)this.proxyToTargetBrokerAddress, (String)this.clientAuthRole, (AuthData)clientAuthData, (String)this.clientAuthMethod, (String)PulsarVersion.getVersion(), null);
    }

    protected void handleAuthChallenge(CommandAuthChallenge authChallenge) {
        Preconditions.checkArgument((boolean)authChallenge.hasChallenge());
        Preconditions.checkArgument((boolean)authChallenge.getChallenge().hasAuthData());
        boolean isRefresh = Arrays.equals(AuthData.REFRESH_AUTH_DATA_BYTES, authChallenge.getChallenge().getAuthData());
        if (this.forwardClientAuthData && isRefresh) {
            ((CompletableFuture)this.proxyConnection.getValidClientAuthData().thenApplyAsync(authData -> {
                NettyChannelUtil.writeAndFlushWithVoidPromise((ChannelOutboundInvoker)this.ctx, (ByteBuf)Commands.newAuthResponse((String)this.clientAuthMethod, (AuthData)authData, (int)this.protocolVersion, (String)String.format("Pulsar-Java-v%s", PulsarVersion.getVersion())));
                return null;
            }, (Executor)this.ctx.executor())).exceptionally(ex -> {
                log.warn("Failed to get valid client auth data. Closing connection.", ex);
                this.ctx.close();
                return null;
            });
        } else {
            super.handleAuthChallenge(authChallenge);
        }
    }
}

