/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import io.opentelemetry.api.OpenTelemetry;
import io.prometheus.client.jetty.JettyStatisticsCollector;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.broker.web.JettyRequestLogFactory;
import org.apache.pulsar.broker.web.JsonMapperProvider;
import org.apache.pulsar.broker.web.RateLimitingFilter;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.util.PulsarSslConfiguration;
import org.apache.pulsar.common.util.PulsarSslFactory;
import org.apache.pulsar.jetty.tls.JettySslContextFactory;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.QoSFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer {
    private static final String MATCH_ALL = "/*";
    private final Server server;
    private final WebExecutorThreadPool webServiceExecutor;
    private final AuthenticationService authenticationService;
    private final List<String> servletPaths = new ArrayList<String>();
    private final List<Handler> handlers = new ArrayList<Handler>();
    private final ProxyConfiguration config;
    protected int externalServicePort;
    private URI serviceURI = null;
    private ServerConnector connector;
    private ServerConnector connectorTls;
    private ScheduledExecutorService sslRefreshScheduledExecutor;
    private PulsarSslFactory sslFactory;
    private final FilterInitializer filterInitializer;
    private static final Logger log = LoggerFactory.getLogger(WebServer.class);

    public WebServer(ProxyConfiguration config, AuthenticationService authenticationService) {
        this.webServiceExecutor = new WebExecutorThreadPool(config.getHttpNumThreads(), "pulsar-external-web", config.getHttpServerThreadPoolQueueSize());
        this.server = new Server((ThreadPool)this.webServiceExecutor);
        if (config.getMaxHttpServerConnections() > 0) {
            this.server.addBean((Object)new ConnectionLimit(config.getMaxHttpServerConnections(), this.server));
        }
        this.authenticationService = authenticationService;
        this.config = config;
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        HttpConfiguration httpConfig = new HttpConfiguration();
        if (config.isWebServiceTrustXForwardedFor()) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        }
        httpConfig.setOutputBufferSize(config.getHttpOutputBufferSize());
        httpConfig.setRequestHeaderSize(config.getHttpMaxRequestHeaderSize());
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
        if (config.getWebServicePort().isPresent()) {
            this.externalServicePort = config.getWebServicePort().get();
            ArrayList<Object> connectionFactories = new ArrayList<Object>();
            if (config.isWebServiceHaProxyProtocolEnabled()) {
                connectionFactories.add(new ProxyConnectionFactory());
            }
            connectionFactories.add(httpConnectionFactory);
            this.connector = new ServerConnector(this.server, connectionFactories.toArray(new ConnectionFactory[0]));
            this.connector.setHost(config.getBindAddress());
            this.connector.setPort(this.externalServicePort);
            connectors.add(this.connector);
        }
        if (config.getWebServicePortTls().isPresent()) {
            try {
                this.sslRefreshScheduledExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ExecutorProvider.ExtendedThreadFactory("pulsar-proxy-web-server-tls-refresh"));
                PulsarSslConfiguration sslConfiguration = this.buildSslConfiguration(config);
                this.sslFactory = (PulsarSslFactory)Class.forName(config.getSslFactoryPlugin()).getConstructor(new Class[0]).newInstance(new Object[0]);
                this.sslFactory.initialize(sslConfiguration);
                this.sslFactory.createInternalSslContext();
                if (config.getTlsCertRefreshCheckDurationSec() > 0L) {
                    this.sslRefreshScheduledExecutor.scheduleWithFixedDelay(this::refreshSslContext, config.getTlsCertRefreshCheckDurationSec(), config.getTlsCertRefreshCheckDurationSec(), TimeUnit.SECONDS);
                }
                SslContextFactory.Server sslCtxFactory = JettySslContextFactory.createSslContextFactory((String)config.getTlsProvider(), (PulsarSslFactory)this.sslFactory, (boolean)config.isTlsRequireTrustedClientCertOnConnect(), config.getWebServiceTlsCiphers(), config.getWebServiceTlsProtocols());
                ArrayList<Object> connectionFactories = new ArrayList<Object>();
                if (config.isWebServiceHaProxyProtocolEnabled()) {
                    connectionFactories.add(new ProxyConnectionFactory());
                }
                connectionFactories.add(new SslConnectionFactory((SslContextFactory)sslCtxFactory, httpConnectionFactory.getProtocol()));
                connectionFactories.add(httpConnectionFactory);
                if (httpConfig.getCustomizer(SecureRequestCustomizer.class) == null) {
                    httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                }
                this.connectorTls = new ServerConnector(this.server, connectionFactories.toArray(new ConnectionFactory[0]));
                this.connectorTls.setPort(config.getWebServicePortTls().get().intValue());
                this.connectorTls.setHost(config.getBindAddress());
                connectors.add(this.connectorTls);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        connectors.stream().forEach(c -> c.setAcceptQueueSize(config.getHttpServerAcceptQueueSize()));
        this.server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
        this.filterInitializer = new FilterInitializer(config, authenticationService);
    }

    public URI getServiceUri() {
        return this.serviceURI;
    }

    public void addServlet(String basePath, ServletHolder servletHolder) {
        this.addServlet(basePath, servletHolder, Collections.emptyList());
    }

    public void addServlet(String basePath, ServletHolder servletHolder, List<Pair<String, Object>> attributes) {
        this.addServlet(basePath, servletHolder, attributes, true);
    }

    public void addServlet(String basePath, ServletHolder servletHolder, List<Pair<String, Object>> attributes, boolean requireAuthentication) {
        this.addServlet(basePath, servletHolder, attributes, requireAuthentication, true);
    }

    private void addServlet(String basePath, ServletHolder servletHolder, List<Pair<String, Object>> attributes, boolean requireAuthentication, boolean checkForExistingPaths) {
        Optional<String> existingPath;
        WebServer.popularServletParams(servletHolder, this.config);
        if (checkForExistingPaths && (existingPath = this.servletPaths.stream().filter(p -> p.startsWith(basePath)).findFirst()).isPresent()) {
            throw new IllegalArgumentException(String.format("Cannot add servlet at %s, path %s already exists", basePath, existingPath.get()));
        }
        this.servletPaths.add(basePath);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(basePath);
        context.addServlet(servletHolder, MATCH_ALL);
        for (Pair<String, Object> attribute : attributes) {
            context.setAttribute((String)attribute.getLeft(), attribute.getRight());
        }
        this.filterInitializer.addFilters(context, requireAuthentication);
        this.handlers.add((Handler)context);
    }

    private static void popularServletParams(ServletHolder servletHolder, ProxyConfiguration config) {
        int requestBufferSize = -1;
        try {
            requestBufferSize = Integer.parseInt(servletHolder.getInitParameter("requestBufferSize"));
        }
        catch (NumberFormatException nfe) {
            log.warn("The init-param {} is invalidated, because it is not a number", (Object)"requestBufferSize");
        }
        if (requestBufferSize > 0 || config.getHttpMaxRequestHeaderSize() > 0) {
            int v = Math.max(requestBufferSize, config.getHttpMaxRequestHeaderSize());
            servletHolder.setInitParameter("requestBufferSize", String.valueOf(v));
        }
    }

    public void addRestResource(String basePath, String attribute, Object attributeValue, Class<?> resourceClass) {
        this.addRestResource(basePath, attribute, attributeValue, resourceClass, true);
    }

    public void addRestResource(String basePath, String attribute, Object attributeValue, Class<?> resourceClass, boolean requireAuthentication) {
        ResourceConfig config = new ResourceConfig();
        config.register(resourceClass);
        config.register(JsonMapperProvider.class);
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer(config));
        servletHolder.setAsyncSupported(true);
        this.addServlet(basePath, servletHolder, Collections.singletonList(Pair.of((Object)attribute, (Object)attributeValue)), requireAuthentication, false);
    }

    public int getExternalServicePort() {
        return this.externalServicePort;
    }

    public void start() throws Exception {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        boolean showDetailedAddresses = this.config.getWebServiceLogDetailedAddresses() != null ? this.config.getWebServiceLogDetailedAddresses() : this.config.isWebServiceHaProxyProtocolEnabled() || this.config.isWebServiceTrustXForwardedFor();
        requestLogHandler.setRequestLog(JettyRequestLogFactory.createRequestLogger((boolean)showDetailedAddresses, (Server)this.server));
        this.handlers.add(0, (Handler)new ContextHandlerCollection());
        this.handlers.add((Handler)requestLogHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
        StatisticsHandler stats = new StatisticsHandler();
        stats.setHandler((Handler)handlerCollection);
        try {
            new JettyStatisticsCollector(stats).register();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.server.setHandler((Handler)stats);
        try {
            this.server.start();
            Arrays.stream(this.server.getConnectors()).filter(c -> c instanceof ServerConnector).findFirst().ifPresent(c -> {
                this.externalServicePort = ((ServerConnector)c).getPort();
            });
            URI reportedURI = this.server.getURI();
            this.serviceURI = new URI(reportedURI.getScheme(), null, reportedURI.getHost(), reportedURI.getPort(), null, null, null);
        }
        catch (Exception e) {
            ArrayList<Integer> ports = new ArrayList<Integer>();
            for (Connector c2 : this.server.getConnectors()) {
                if (!(c2 instanceof ServerConnector)) continue;
                ports.add(((ServerConnector)c2).getPort());
            }
            throw new IOException("Failed to start HTTP server on ports " + String.valueOf(ports), e);
        }
        log.info("Server started at end point {}", (Object)this.getServiceUri());
    }

    public void stop() throws Exception {
        if (this.sslRefreshScheduledExecutor != null) {
            this.sslRefreshScheduledExecutor.shutdownNow();
        }
        this.server.stop();
        this.webServiceExecutor.stop();
        log.info("Server stopped successfully");
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public Optional<Integer> getListenPortHTTP() {
        if (this.connector != null) {
            return Optional.of(this.connector.getLocalPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortHTTPS() {
        if (this.connectorTls != null) {
            return Optional.of(this.connectorTls.getLocalPort());
        }
        return Optional.empty();
    }

    protected PulsarSslConfiguration buildSslConfiguration(ProxyConfiguration config) {
        return PulsarSslConfiguration.builder().tlsProvider(config.getTlsProvider()).tlsKeyStoreType(config.getTlsKeyStoreType()).tlsKeyStorePath(config.getTlsKeyStore()).tlsKeyStorePassword(config.getTlsKeyStorePassword()).tlsTrustStoreType(config.getTlsTrustStoreType()).tlsTrustStorePath(config.getTlsTrustStore()).tlsTrustStorePassword(config.getTlsTrustStorePassword()).tlsCiphers(config.getTlsCiphers()).tlsProtocols(config.getTlsProtocols()).tlsTrustCertsFilePath(config.getTlsTrustCertsFilePath()).tlsCertificateFilePath(config.getTlsCertificateFilePath()).tlsKeyFilePath(config.getTlsKeyFilePath()).allowInsecureConnection(config.isTlsAllowInsecureConnection()).requireTrustedClientCertOnConnect(config.isTlsRequireTrustedClientCertOnConnect()).tlsEnabledWithKeystore(config.isTlsEnabledWithKeyStore()).tlsCustomParams(config.getSslFactoryPluginParams()).authData(null).serverMode(true).isHttps(true).build();
    }

    protected void refreshSslContext() {
        try {
            this.sslFactory.update();
        }
        catch (Exception e) {
            log.error("Failed to refresh SSL context", (Throwable)e);
        }
    }

    private static class FilterInitializer {
        private final List<FilterHolder> filterHolders = new ArrayList<FilterHolder>();
        private final FilterHolder authenticationFilterHolder;

        FilterInitializer(ProxyConfiguration config, AuthenticationService authenticationService) {
            if (config.getMaxConcurrentHttpRequests() > 0) {
                FilterHolder filterHolder = new FilterHolder(QoSFilter.class);
                filterHolder.setInitParameter("maxRequests", String.valueOf(config.getMaxConcurrentHttpRequests()));
                this.filterHolders.add(filterHolder);
            }
            if (config.isHttpRequestsLimitEnabled()) {
                this.filterHolders.add(new FilterHolder((Filter)new RateLimitingFilter(config.getHttpRequestsMaxPerSecond(), OpenTelemetry.noop().getMeter("org.apache.pulsar.proxy"))));
            }
            if (config.isAuthenticationEnabled()) {
                this.authenticationFilterHolder = new FilterHolder((Filter)new AuthenticationFilter(authenticationService));
                this.filterHolders.add(this.authenticationFilterHolder);
            } else {
                this.authenticationFilterHolder = null;
            }
        }

        public void addFilters(ServletContextHandler context, boolean requiresAuthentication) {
            for (FilterHolder filterHolder : this.filterHolders) {
                if (!requiresAuthentication && filterHolder == this.authenticationFilterHolder) continue;
                context.addFilter(filterHolder, WebServer.MATCH_ALL, EnumSet.allOf(DispatcherType.class));
            }
        }
    }
}

