/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.bookkeeper.bookie.storage.directentrylogger.Buffer;
import org.apache.bookkeeper.bookie.storage.directentrylogger.BufferPool;
import org.apache.bookkeeper.bookie.storage.directentrylogger.Events;
import org.apache.bookkeeper.bookie.storage.directentrylogger.LogWriter;
import org.apache.bookkeeper.common.util.ExceptionMessageHelper;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.bookkeeper.common.util.nativeio.NativeIOException;
import org.apache.bookkeeper.slogger.Slogger;
import org.apache.commons.lang3.SystemUtils;

class DirectWriter
implements LogWriter {
    final NativeIO nativeIO;
    final int fd;
    final int id;
    final String filename;
    final BufferPool bufferPool;
    final ExecutorService writeExecutor;
    final Object bufferLock = new Object();
    final List<Future<?>> outstandingWrites = new ArrayList();
    final Slogger slog;
    Buffer nativeBuffer;
    long offset;
    private static volatile boolean useFallocate = true;

    DirectWriter(int id, String filename, long maxFileSize, ExecutorService writeExecutor, BufferPool bufferPool, NativeIO nativeIO, Slogger slog) throws IOException {
        Preconditions.checkArgument((maxFileSize > 0L ? 1 : 0) != 0, (Object)"Max file size (%d) must be positive");
        this.id = id;
        this.filename = filename;
        this.writeExecutor = writeExecutor;
        this.nativeIO = nativeIO;
        this.slog = slog.ctx(DirectWriter.class);
        this.offset = 0L;
        try {
            this.fd = nativeIO.open(filename, 21, 420);
            Preconditions.checkState((this.fd >= 0 ? 1 : 0) != 0, (String)"Open should have thrown exception, fd is invalid : %d", (int)this.fd);
        }
        catch (NativeIOException ne) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)ne.getMessage()).kv("file", (Object)filename).kv("errno", (Object)ne.getErrno()).toString(), ne);
        }
        if (useFallocate) {
            if (!SystemUtils.IS_OS_LINUX) {
                DirectWriter.disableUseFallocate();
                this.slog.warn((Enum)Events.FALLOCATE_NOT_AVAILABLE);
            } else {
                try {
                    int ret = nativeIO.fallocate(this.fd, 16, 0L, maxFileSize);
                    Preconditions.checkState((ret == 0 ? 1 : 0) != 0, (String)"Exception should have been thrown on non-zero ret: %d", (int)ret);
                }
                catch (NativeIOException ex) {
                    DirectWriter.disableUseFallocate();
                    this.slog.kv((Object)"message", (Object)ex.getMessage()).kv((Object)"file", (Object)filename).kv((Object)"errno", (Object)ex.getErrno()).warn((Enum)Events.FALLOCATE_NOT_AVAILABLE);
                }
            }
        }
        this.bufferPool = bufferPool;
        this.nativeBuffer = bufferPool.acquire();
    }

    private static void disableUseFallocate() {
        useFallocate = false;
    }

    @Override
    public int logId() {
        return this.id;
    }

    @Override
    public void writeAt(long offset, ByteBuf buf) throws IOException {
        Preconditions.checkArgument((boolean)Buffer.isAligned(offset), (String)"Offset to writeAt must be aligned to %d: %d is not", (int)4096, (long)offset);
        Preconditions.checkArgument((boolean)Buffer.isAligned(buf.readableBytes()), (String)"Buffer must write multiple of alignment bytes (%d), %d is not", (int)4096, (int)buf.readableBytes());
        int bytesToWrite = buf.readableBytes();
        if (bytesToWrite <= 0) {
            return;
        }
        Buffer tmpBuffer = this.bufferPool.acquire();
        tmpBuffer.reset();
        tmpBuffer.writeByteBuf(buf);
        Future<Object> f = this.writeExecutor.submit(() -> {
            this.writeByteBuf(tmpBuffer, bytesToWrite, offset);
            return null;
        });
        this.addOutstandingWrite(f);
    }

    private void writeByteBuf(Buffer buffer, int bytesToWrite, long offsetToWrite) throws IOException {
        try {
            if (bytesToWrite <= 0) {
                return;
            }
            int ret = this.nativeIO.pwrite(this.fd, buffer.pointer(), bytesToWrite, offsetToWrite);
            if (ret != bytesToWrite) {
                throw new IOException(ExceptionMessageHelper.exMsg((String)"Incomplete write").kv("filename", (Object)this.filename).kv("pointer", (Object)buffer.pointer()).kv("offset", (Object)offsetToWrite).kv("writeSize", (Object)bytesToWrite).kv("bytesWritten", (Object)ret).toString());
            }
        }
        catch (NativeIOException ne) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)"Write error").kv("filename", (Object)this.filename).kv("offset", (Object)offsetToWrite).kv("writeSize", (Object)bytesToWrite).kv("pointer", (Object)buffer.pointer()).kv("errno", (Object)ne.getErrno()).toString());
        }
        finally {
            this.bufferPool.release(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeDelimited(ByteBuf buf) throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            if (!this.nativeBuffer.hasSpace(this.serializedSize(buf))) {
                this.flushBuffer();
            }
            int readable = buf.readableBytes();
            long bufferPosition = this.position() + 4L;
            if (bufferPosition > Integer.MAX_VALUE) {
                throw new IOException(ExceptionMessageHelper.exMsg((String)"Cannot write past max int").kv("filename", (Object)this.filename).kv("writeSize", (Object)readable).kv("position", (Object)bufferPosition).toString());
            }
            this.nativeBuffer.writeInt(readable);
            this.nativeBuffer.writeByteBuf(buf);
            return (int)bufferPosition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void position(long offset) throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.nativeBuffer != null && this.nativeBuffer.position() > 0) {
                this.flushBuffer();
            }
            if (offset % 4096L != 0L) {
                throw new IOException(ExceptionMessageHelper.exMsg((String)"offset must be multiple of alignment").kv("offset", (Object)offset).kv("alignment", (Object)4096).toString());
            }
            this.offset = offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() {
        Object object = this.bufferLock;
        synchronized (object) {
            return this.offset + (long)(this.nativeBuffer != null ? this.nativeBuffer.position() : 0);
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.waitForOutstandingWrites();
        try {
            int ret = this.nativeIO.fsync(this.fd);
            Preconditions.checkState((ret == 0 ? 1 : 0) != 0, (String)"Fsync should throw exception on non-zero return (%d)", (int)ret);
        }
        catch (NativeIOException ne) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)ne.getMessage()).kv("file", (Object)this.filename).kv("errno", (Object)ne.getErrno()).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.nativeBuffer != null && this.nativeBuffer.position() > 0) {
                this.flush();
            }
        }
        try {
            int ret = this.nativeIO.close(this.fd);
            Preconditions.checkState((ret == 0 ? 1 : 0) != 0, (String)"Close should throw exception on non-zero return (%d)", (int)ret);
        }
        catch (NativeIOException ne) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)ne.getMessage()).kv("file", (Object)this.filename).kv("errno", (Object)ne.getErrno()).toString());
        }
        finally {
            Object object2 = this.bufferLock;
            synchronized (object2) {
                this.bufferPool.release(this.nativeBuffer);
                this.nativeBuffer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOutstandingWrite(Future<?> toAdd) throws IOException {
        List<Future<?>> list = this.outstandingWrites;
        synchronized (list) {
            Future<?> f;
            this.outstandingWrites.add(toAdd);
            Iterator<Future<?>> iter = this.outstandingWrites.iterator();
            while (iter.hasNext() && (f = iter.next()).isDone()) {
                this.waitForFuture(f);
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOutstandingWrites() throws IOException {
        List<Future<?>> list = this.outstandingWrites;
        synchronized (list) {
            Iterator<Future<?>> iter = this.outstandingWrites.iterator();
            while (iter.hasNext()) {
                Future<?> f = iter.next();
                this.waitForFuture(f);
                iter.remove();
            }
        }
    }

    private void waitForFuture(Future<?> f) throws IOException {
        try {
            f.get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException(ie);
        }
        catch (Throwable t) {
            if (t.getCause() instanceof IOException) {
                throw (IOException)t.getCause();
            }
            throw new IOException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.nativeBuffer != null) {
                int bytesToWrite = this.nativeBuffer.padToAlignment();
                if (bytesToWrite == 0) {
                    return;
                }
                Buffer bufferToFlush = this.nativeBuffer;
                this.nativeBuffer = null;
                long offsetToWrite = this.offset;
                this.offset += (long)bytesToWrite;
                Future<Object> f = this.writeExecutor.submit(() -> {
                    this.writeByteBuf(bufferToFlush, bytesToWrite, offsetToWrite);
                    return null;
                });
                this.addOutstandingWrite(f);
                this.nativeBuffer = this.bufferPool.acquire();
            }
        }
    }

    @Override
    public int serializedSize(ByteBuf buf) {
        return buf.readableBytes() + 4;
    }
}

