/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.verifier;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.verifier.BookkeeperVerifier;

class DirectBookkeeperDriver
implements BookkeeperVerifier.BookkeeperDriver {
    private final ConcurrentHashMap<Long, LedgerHandle> openHandles = new ConcurrentHashMap();
    private BookKeeper client;

    DirectBookkeeperDriver(BookKeeper client) {
        this.client = client;
    }

    @Override
    public void createLedger(long ledgerID, int enSize, int writeQSize, int ackQSize, Consumer<Integer> cb) {
        this.client.asyncCreateLedgerAdv(ledgerID, enSize, writeQSize, ackQSize, BookKeeper.DigestType.CRC32, new byte[0], (rc, lh, ctx) -> {
            this.openHandles.put(ledgerID, lh);
            cb.accept(rc);
        }, null, null);
    }

    @Override
    public void closeLedger(long ledgerID, Consumer<Integer> cb) {
        LedgerHandle handle = this.openHandles.remove(ledgerID);
        handle.asyncClose((rc, lh, ctx) -> cb.accept(rc), null);
    }

    @Override
    public void deleteLedger(long ledgerID, Consumer<Integer> cb) {
        this.client.asyncDeleteLedger(ledgerID, (rc, ctx) -> cb.accept(rc), null);
    }

    @Override
    public void writeEntry(long ledgerID, long entryID, byte[] data, Consumer<Integer> cb) {
        LedgerHandle handle = this.openHandles.get(ledgerID);
        if (handle == null) {
            cb.accept(-12);
            return;
        }
        handle.asyncAddEntry(entryID, data, (rc, lh, entryId, ctx) -> cb.accept(rc), null);
    }

    @Override
    public void readEntries(long ledgerID, long firstEntryID, long lastEntryID, BiConsumer<Integer, ArrayList<byte[]>> cb) {
        this.client.asyncOpenLedgerNoRecovery(ledgerID, BookKeeper.DigestType.CRC32, new byte[0], (rc, lh, ctx) -> {
            if (rc != 0) {
                cb.accept(rc, null);
                return;
            }
            System.out.format("Got handle for read %d -> %d on ledger %d%n", firstEntryID, lastEntryID, ledgerID);
            lh.asyncReadEntries(firstEntryID, lastEntryID, (rc1, lh1, seq, ctx1) -> {
                System.out.format("Read cb %d -> %d on ledger %d%n", firstEntryID, lastEntryID, ledgerID);
                ArrayList<byte[]> results = new ArrayList<byte[]>();
                if (rc1 == 0) {
                    while (seq.hasMoreElements()) {
                        results.add(((LedgerEntry)seq.nextElement()).getEntry());
                    }
                    System.out.format("About to close handle for read %d -> %d on ledger %d%n", firstEntryID, lastEntryID, ledgerID);
                }
                lh.asyncClose((rc2, lh2, ctx2) -> {
                    System.out.format("Closed handle for read %d -> %d on ledger %d result %d%n", firstEntryID, lastEntryID, ledgerID, rc2);
                    cb.accept(rc1 == 0 ? rc2 : rc1, results);
                }, null);
            }, null);
        }, null);
    }
}

