/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.extensions;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.proxy.extensions.ProxyExtension;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProxyExtensionWithClassLoader
implements ProxyExtension {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxyExtensionWithClassLoader.class);
    private final ProxyExtension extension;
    private final NarClassLoader classLoader;

    @Override
    public String extensionName() {
        try (ClassLoaderSwitcher ignored = new ClassLoaderSwitcher((ClassLoader)this.classLoader);){
            String string = this.extension.extensionName();
            return string;
        }
    }

    @Override
    public boolean accept(String extensionName) {
        try (ClassLoaderSwitcher ignored = new ClassLoaderSwitcher((ClassLoader)this.classLoader);){
            boolean bl = this.extension.accept(extensionName);
            return bl;
        }
    }

    @Override
    public void initialize(ProxyConfiguration conf) throws Exception {
        try (ClassLoaderSwitcher ignored = new ClassLoaderSwitcher((ClassLoader)this.classLoader);){
            this.extension.initialize(conf);
        }
    }

    @Override
    public void start(ProxyService service) {
        try (ClassLoaderSwitcher ignored = new ClassLoaderSwitcher((ClassLoader)this.classLoader);){
            this.extension.start(service);
        }
    }

    @Override
    public Map<InetSocketAddress, ChannelInitializer<SocketChannel>> newChannelInitializers() {
        try (ClassLoaderSwitcher ignored = new ClassLoaderSwitcher((ClassLoader)this.classLoader);){
            Map<InetSocketAddress, ChannelInitializer<SocketChannel>> map = this.extension.newChannelInitializers();
            return map;
        }
    }

    @Override
    public void close() {
        try (ClassLoaderSwitcher ignored = new ClassLoaderSwitcher((ClassLoader)this.classLoader);){
            this.extension.close();
        }
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            log.warn("Failed to close the extension class loader", (Throwable)e);
        }
    }

    @Generated
    public ProxyExtension getExtension() {
        return this.extension;
    }

    @Generated
    public NarClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyExtensionWithClassLoader)) {
            return false;
        }
        ProxyExtensionWithClassLoader other = (ProxyExtensionWithClassLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ProxyExtension this$extension = this.getExtension();
        ProxyExtension other$extension = other.getExtension();
        if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
            return false;
        }
        NarClassLoader this$classLoader = this.getClassLoader();
        NarClassLoader other$classLoader = other.getClassLoader();
        return !(this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProxyExtensionWithClassLoader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProxyExtension $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        NarClassLoader $classLoader = this.getClassLoader();
        result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProxyExtensionWithClassLoader(extension=" + String.valueOf(this.getExtension()) + ", classLoader=" + String.valueOf(this.getClassLoader()) + ")";
    }

    @Generated
    public ProxyExtensionWithClassLoader(ProxyExtension extension, NarClassLoader classLoader) {
        this.extension = extension;
        this.classLoader = classLoader;
    }

    private static class ClassLoaderSwitcher
    implements AutoCloseable {
        private final ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();

        ClassLoaderSwitcher(ClassLoader classLoader) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }

        @Override
        public void close() {
            Thread.currentThread().setContextClassLoader(this.prevClassLoader);
        }
    }
}

