/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.packages.management.storage.bookkeeper;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DLOutputStream {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DLOutputStream.class);
    private final DistributedLogManager distributedLogManager;
    private final AsyncLogWriter writer;
    private final byte[] readBuffer = new byte[1040364];
    private long offset = 0L;

    private DLOutputStream(DistributedLogManager distributedLogManager, AsyncLogWriter writer) {
        this.distributedLogManager = distributedLogManager;
        this.writer = writer;
    }

    static CompletableFuture<DLOutputStream> openWriterAsync(DistributedLogManager distributedLogManager) {
        log.info("Open a dlog manager");
        return distributedLogManager.openAsyncLogWriter().thenApply(w -> new DLOutputStream(distributedLogManager, (AsyncLogWriter)w));
    }

    private void writeAsyncHelper(InputStream is, CompletableFuture<DLOutputStream> result) {
        try {
            int read = is.readNBytes(this.readBuffer, 0, this.readBuffer.length);
            if (read > 0) {
                log.debug("write something into the ledgers offset: {}, length: {}", (Object)this.offset, (Object)read);
                ByteBuf writeBuf = Unpooled.wrappedBuffer((byte[])this.readBuffer, (int)0, (int)read);
                this.offset += (long)writeBuf.readableBytes();
                LogRecord record = new LogRecord(this.offset, writeBuf);
                ((CompletableFuture)this.writer.write(record).thenAccept(v -> this.writeAsyncHelper(is, result))).exceptionally(e -> {
                    result.completeExceptionally((Throwable)e);
                    return null;
                });
            } else {
                result.complete(this);
            }
        }
        catch (IOException e2) {
            log.error("Failed to get all records from the input stream", (Throwable)e2);
            result.completeExceptionally(e2);
        }
    }

    CompletableFuture<DLOutputStream> writeAsync(InputStream inputStream) {
        CompletableFuture<DLOutputStream> result = new CompletableFuture<DLOutputStream>();
        this.writeAsyncHelper(inputStream, result);
        return result;
    }

    CompletableFuture<Void> closeAsync() {
        return ((CompletableFuture)this.writer.markEndOfStream().thenCompose(ignore -> this.writer.asyncClose())).thenCompose(ignore -> this.distributedLogManager.asyncClose());
    }
}

