/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.testclient;

import java.util.concurrent.Callable;
import picocli.CommandLine;

public abstract class CmdBase
implements Callable<Integer> {
    private final CommandLine commander = new CommandLine((Object)this);

    public CmdBase(String cmdName) {
        this.commander.setCommandName(cmdName);
    }

    public boolean run(String[] args) {
        return this.commander.execute(args) == 0;
    }

    public void parse(String[] args) {
        this.commander.parseArgs(args);
    }

    public void validate() throws Exception {
    }

    @Override
    public Integer call() throws Exception {
        this.validate();
        this.run();
        return 0;
    }

    public abstract void run() throws Exception;

    protected CommandLine getCommander() {
        return this.commander;
    }

    protected void addCommand(String name, Object cmd) {
        this.commander.addSubcommand(name, cmd);
    }

    protected void addCommand(String name, Object cmd, String ... aliases) {
        this.commander.addSubcommand(name, cmd, aliases);
    }

    protected class ParameterException
    extends CommandLine.ParameterException {
        public ParameterException(String msg) {
            super(CmdBase.this.commander, msg);
        }

        public ParameterException(String msg, Throwable e) {
            super(CmdBase.this.commander, msg, e);
        }
    }
}

