/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl;

import java.security.cert.Certificate;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.pulsar.jetcd.shaded.io.vertx.codegen.annotations.Nullable;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.MultiMap;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpHeaders;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpServerRequest;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.ServerWebSocket;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.ServerWebSocketHandshake;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.Http1xServerRequest;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpServerConnectionHandler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.ServerWebSocketImpl;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.HostAndPort;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.SocketAddress;

public class Http1xServerRequestHandler
implements Handler<HttpServerRequest> {
    private final HttpServerConnectionHandler handlers;

    public Http1xServerRequestHandler(HttpServerConnectionHandler handlers) {
        this.handlers = handlers;
    }

    @Override
    public void handle(HttpServerRequest req) {
        final Handler<ServerWebSocket> wsHandler = this.handlers.wsHandler;
        Handler<HttpServerRequest> reqHandler = this.handlers.requestHandler;
        Handler<ServerWebSocketHandshake> wsHandshakeHandler = this.handlers.wsHandshakeHandler;
        if (wsHandler != null) {
            if (req.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true) && this.handlers.server.wsAccept()) {
                Future<ServerWebSocket> fut = ((Http1xServerRequest)req).webSocket();
                if (wsHandshakeHandler != null) {
                    fut.onComplete(ar -> {
                        if (ar.succeeded()) {
                            final ServerWebSocket ws = (ServerWebSocket)ar.result();
                            final Promise promise = Promise.promise();
                            ws.setHandshake(promise.future());
                            wsHandshakeHandler.handle(new ServerWebSocketHandshake(){

                                @Override
                                public MultiMap headers() {
                                    return ws.headers();
                                }

                                @Override
                                public @Nullable String scheme() {
                                    return ws.scheme();
                                }

                                @Override
                                public @Nullable HostAndPort authority() {
                                    return ws.authority();
                                }

                                @Override
                                public String uri() {
                                    return ws.uri();
                                }

                                @Override
                                public String path() {
                                    return ws.path();
                                }

                                @Override
                                public @Nullable String query() {
                                    return ws.query();
                                }

                                @Override
                                public Future<ServerWebSocket> accept() {
                                    promise.complete(101);
                                    wsHandler.handle(ws);
                                    return Future.succeededFuture(ws);
                                }

                                @Override
                                public Future<Void> reject(int status) {
                                    promise.complete(status);
                                    return Future.succeededFuture();
                                }

                                @Override
                                public SocketAddress remoteAddress() {
                                    return ws.remoteAddress();
                                }

                                @Override
                                public SocketAddress localAddress() {
                                    return ws.localAddress();
                                }

                                @Override
                                public boolean isSsl() {
                                    return ws.isSsl();
                                }

                                @Override
                                public SSLSession sslSession() {
                                    return ws.sslSession();
                                }

                                @Override
                                public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
                                    return ws.peerCertificates();
                                }
                            });
                        }
                    });
                } else {
                    fut.onComplete(ar -> {
                        if (ar.succeeded()) {
                            ServerWebSocketImpl ws = (ServerWebSocketImpl)ar.result();
                            wsHandler.handle(ws);
                            ws.tryHandshake(101);
                        }
                    });
                }
            } else if (reqHandler != null) {
                reqHandler.handle(req);
            } else {
                req.response().setStatusCode(400).end();
            }
        } else if (req.version() == null) {
            req.response().setStatusCode(501).end();
            req.response().close();
        } else {
            reqHandler.handle(req);
        }
    }
}

