/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8;

import com.sun.management.GarbageCollectionNotificationInfo;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public final class GarbageCollector {
    private static final Logger logger = Logger.getLogger(GarbageCollector.class.getName());
    private static final double MILLIS_PER_S = TimeUnit.SECONDS.toMillis(1L);
    private static final AttributeKey<String> GC_KEY = AttributeKey.stringKey((String)"gc");
    private static final AttributeKey<String> ACTION_KEY = AttributeKey.stringKey((String)"action");
    private static final AttributeKey<String> JVM_GC_NAME = AttributeKey.stringKey((String)"jvm.gc.name");
    private static final AttributeKey<String> JVM_GC_ACTION = AttributeKey.stringKey((String)"jvm.gc.action");
    static final List<Double> GC_DURATION_BUCKETS = Collections.unmodifiableList(Arrays.asList(0.01, 0.1, 1.0, 10.0));
    private static final NotificationFilter GC_FILTER = notification -> notification.getType().equals("com.sun.management.gc.notification");

    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        if (!GarbageCollector.isNotificationClassPresent()) {
            logger.fine("The com.sun.management.GarbageCollectionNotificationInfo class is not available; GC metrics will not be reported.");
            return Collections.emptyList();
        }
        return GarbageCollector.registerObservers(openTelemetry, ManagementFactory.getGarbageCollectorMXBeans(), GarbageCollector::extractNotificationInfo);
    }

    static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, List<GarbageCollectorMXBean> gcBeans, Function<Notification, GarbageCollectionNotificationInfo> notificationInfoExtractor) {
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        DoubleHistogram oldGcDuration = null;
        DoubleHistogram stableGcDuration = null;
        if (SemconvStability.emitOldJvmSemconv()) {
            oldGcDuration = meter.histogramBuilder("process.runtime.jvm.gc.duration").setDescription("Duration of JVM garbage collection actions").setUnit("s").setExplicitBucketBoundariesAdvice(Collections.emptyList()).build();
        }
        if (SemconvStability.emitStableJvmSemconv()) {
            stableGcDuration = meter.histogramBuilder("jvm.gc.duration").setDescription("Duration of JVM garbage collection actions.").setUnit("s").setExplicitBucketBoundariesAdvice(GC_DURATION_BUCKETS).build();
        }
        ArrayList<AutoCloseable> result = new ArrayList<AutoCloseable>();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            if (!(gcBean instanceof NotificationEmitter)) continue;
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)gcBean);
            GcNotificationListener listener = new GcNotificationListener(oldGcDuration, stableGcDuration, notificationInfoExtractor);
            notificationEmitter.addNotificationListener(listener, GC_FILTER, null);
            result.add(() -> notificationEmitter.removeNotificationListener(listener));
        }
        return result;
    }

    private static GarbageCollectionNotificationInfo extractNotificationInfo(Notification notification) {
        return GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
    }

    private static boolean isNotificationClassPresent() {
        try {
            Class.forName("com.sun.management.GarbageCollectionNotificationInfo", false, GarbageCollectorMXBean.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private GarbageCollector() {
    }

    private static final class GcNotificationListener
    implements NotificationListener {
        @Nullable
        private final DoubleHistogram oldGcDuration;
        @Nullable
        private final DoubleHistogram stableGcDuration;
        private final Function<Notification, GarbageCollectionNotificationInfo> notificationInfoExtractor;

        private GcNotificationListener(@Nullable DoubleHistogram oldGcDuration, @Nullable DoubleHistogram stableGcDuration, Function<Notification, GarbageCollectionNotificationInfo> notificationInfoExtractor) {
            this.oldGcDuration = oldGcDuration;
            this.stableGcDuration = stableGcDuration;
            this.notificationInfoExtractor = notificationInfoExtractor;
        }

        @Override
        public void handleNotification(Notification notification, Object unused) {
            GarbageCollectionNotificationInfo notificationInfo = this.notificationInfoExtractor.apply(notification);
            String gcName = notificationInfo.getGcName();
            String gcAction = notificationInfo.getGcAction();
            double duration = (double)notificationInfo.getGcInfo().getDuration() / MILLIS_PER_S;
            if (this.oldGcDuration != null) {
                this.oldGcDuration.record(duration, Attributes.of((AttributeKey)GC_KEY, (Object)gcName, (AttributeKey)ACTION_KEY, (Object)gcAction));
            }
            if (this.stableGcDuration != null) {
                this.stableGcDuration.record(duration, Attributes.of((AttributeKey)JVM_GC_NAME, (Object)gcName, (AttributeKey)JVM_GC_ACTION, (Object)gcAction));
            }
        }
    }
}

