/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl.batching;

import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.metadata.impl.batching.MetadataOp;
import org.apache.pulsar.metadata.impl.batching.MetadataStoreBatchStrategy;
import org.jctools.queues.MessagePassingQueue;

public class DefaultMetadataStoreBatchStrategy
implements MetadataStoreBatchStrategy {
    private final int maxOperations;
    private final int maxPutSize;

    public DefaultMetadataStoreBatchStrategy(int maxOperations, int maxPutSize) {
        this.maxOperations = maxOperations;
        this.maxPutSize = maxPutSize;
    }

    @Override
    public List<MetadataOp> nextBatch(MessagePassingQueue<MetadataOp> opsSrc) {
        MetadataOp op;
        int requestSize = 0;
        ArrayList<MetadataOp> ops = new ArrayList<MetadataOp>();
        while (!opsSrc.isEmpty() && (op = (MetadataOp)opsSrc.peek()) != null) {
            MetadataOp.Type type = op.getType();
            switch (type) {
                case PUT: 
                case DELETE: {
                    requestSize += op.size();
                    break;
                }
            }
            if (!ops.isEmpty() && requestSize > this.maxPutSize) break;
            ops.add((MetadataOp)opsSrc.poll());
            if (ops.size() != this.maxOperations) continue;
            break;
        }
        return ops;
    }
}

