/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.common.api.proto.ServerError;

public final class CommandPartitionedTopicMetadataResponse {
    private int partitions;
    private static final int _PARTITIONS_FIELD_NUMBER = 1;
    private static final int _PARTITIONS_TAG = 8;
    private static final int _PARTITIONS_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _PARTITIONS_MASK = 1;
    private long requestId;
    private static final int _REQUEST_ID_FIELD_NUMBER = 2;
    private static final int _REQUEST_ID_TAG = 16;
    private static final int _REQUEST_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _REQUEST_ID_MASK = 2;
    private LookupType response;
    private static final int _RESPONSE_FIELD_NUMBER = 3;
    private static final int _RESPONSE_TAG = 24;
    private static final int _RESPONSE_TAG_SIZE = LightProtoCodec.computeVarIntSize(24);
    private static final int _RESPONSE_MASK = 4;
    private ServerError error;
    private static final int _ERROR_FIELD_NUMBER = 4;
    private static final int _ERROR_TAG = 32;
    private static final int _ERROR_TAG_SIZE = LightProtoCodec.computeVarIntSize(32);
    private static final int _ERROR_MASK = 8;
    private String message;
    private int _messageBufferIdx = -1;
    private int _messageBufferLen = -1;
    private static final int _MESSAGE_FIELD_NUMBER = 5;
    private static final int _MESSAGE_TAG = 42;
    private static final int _MESSAGE_TAG_SIZE = LightProtoCodec.computeVarIntSize(42);
    private static final int _MESSAGE_MASK = 16;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 2;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasPartitions() {
        return (this._bitField0 & 1) != 0;
    }

    public int getPartitions() {
        if (!this.hasPartitions()) {
            throw new IllegalStateException("Field 'partitions' is not set");
        }
        return this.partitions;
    }

    public CommandPartitionedTopicMetadataResponse setPartitions(int partitions) {
        this.partitions = partitions;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public CommandPartitionedTopicMetadataResponse clearPartitions() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public boolean hasRequestId() {
        return (this._bitField0 & 2) != 0;
    }

    public long getRequestId() {
        if (!this.hasRequestId()) {
            throw new IllegalStateException("Field 'request_id' is not set");
        }
        return this.requestId;
    }

    public CommandPartitionedTopicMetadataResponse setRequestId(long requestId) {
        this.requestId = requestId;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public CommandPartitionedTopicMetadataResponse clearRequestId() {
        this._bitField0 &= 0xFFFFFFFD;
        return this;
    }

    public boolean hasResponse() {
        return (this._bitField0 & 4) != 0;
    }

    public LookupType getResponse() {
        if (!this.hasResponse()) {
            throw new IllegalStateException("Field 'response' is not set");
        }
        return this.response;
    }

    public CommandPartitionedTopicMetadataResponse setResponse(LookupType response) {
        this.response = response;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public CommandPartitionedTopicMetadataResponse clearResponse() {
        this._bitField0 &= 0xFFFFFFFB;
        return this;
    }

    public boolean hasError() {
        return (this._bitField0 & 8) != 0;
    }

    public ServerError getError() {
        if (!this.hasError()) {
            throw new IllegalStateException("Field 'error' is not set");
        }
        return this.error;
    }

    public CommandPartitionedTopicMetadataResponse setError(ServerError error) {
        this.error = error;
        this._bitField0 |= 8;
        this._cachedSize = -1;
        return this;
    }

    public CommandPartitionedTopicMetadataResponse clearError() {
        this._bitField0 &= 0xFFFFFFF7;
        return this;
    }

    public boolean hasMessage() {
        return (this._bitField0 & 0x10) != 0;
    }

    public String getMessage() {
        if (!this.hasMessage()) {
            throw new IllegalStateException("Field 'message' is not set");
        }
        if (this.message == null) {
            this.message = LightProtoCodec.readString(this._parsedBuffer, this._messageBufferIdx, this._messageBufferLen);
        }
        return this.message;
    }

    public CommandPartitionedTopicMetadataResponse setMessage(String message) {
        this.message = message;
        this._bitField0 |= 0x10;
        this._messageBufferIdx = -1;
        this._messageBufferLen = LightProtoCodec.computeStringUTF8Size(message);
        this._cachedSize = -1;
        return this;
    }

    public CommandPartitionedTopicMetadataResponse clearMessage() {
        this._bitField0 &= 0xFFFFFFEF;
        this.message = null;
        this._messageBufferIdx = -1;
        this._messageBufferLen = -1;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        if (this.hasPartitions()) {
            LightProtoCodec.writeVarInt(_b, 8);
            LightProtoCodec.writeVarInt(_b, this.partitions);
        }
        LightProtoCodec.writeVarInt(_b, 16);
        LightProtoCodec.writeVarInt64(_b, this.requestId);
        if (this.hasResponse()) {
            LightProtoCodec.writeVarInt(_b, 24);
            LightProtoCodec.writeVarInt(_b, this.response.getValue());
        }
        if (this.hasError()) {
            LightProtoCodec.writeVarInt(_b, 32);
            LightProtoCodec.writeVarInt(_b, this.error.getValue());
        }
        if (this.hasMessage()) {
            LightProtoCodec.writeVarInt(_b, 42);
            LightProtoCodec.writeVarInt(_b, this._messageBufferLen);
            if (this._messageBufferIdx == -1) {
                LightProtoCodec.writeString(_b, this.message, this._messageBufferLen);
            } else {
                this._parsedBuffer.getBytes(this._messageBufferIdx, _b, this._messageBufferLen);
            }
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        if (this.hasPartitions()) {
            _size += _PARTITIONS_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.partitions);
        }
        _size += _REQUEST_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.requestId);
        if (this.hasResponse()) {
            _size += _RESPONSE_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.response.getValue());
        }
        if (this.hasError()) {
            _size += _ERROR_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.error.getValue());
        }
        if (this.hasMessage()) {
            _size += _MESSAGE_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this._messageBufferLen);
            _size += this._messageBufferLen;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block7: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    this._bitField0 |= 1;
                    this.partitions = LightProtoCodec.readVarInt(_buffer);
                    continue block7;
                }
                case 16: {
                    this._bitField0 |= 2;
                    this.requestId = LightProtoCodec.readVarInt64(_buffer);
                    continue block7;
                }
                case 24: {
                    LookupType _response = LookupType.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_response == null) continue block7;
                    this._bitField0 |= 4;
                    this.response = _response;
                    continue block7;
                }
                case 32: {
                    ServerError _error = ServerError.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_error == null) continue block7;
                    this._bitField0 |= 8;
                    this.error = _error;
                    continue block7;
                }
                case 42: {
                    this._bitField0 |= 0x10;
                    this._messageBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._messageBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._messageBufferLen);
                    continue block7;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 2) != 2) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public CommandPartitionedTopicMetadataResponse clear() {
        this.message = null;
        this._messageBufferIdx = -1;
        this._messageBufferLen = -1;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public CommandPartitionedTopicMetadataResponse copyFrom(CommandPartitionedTopicMetadataResponse _other) {
        this._cachedSize = -1;
        if (_other.hasPartitions()) {
            this.setPartitions(_other.partitions);
        }
        if (_other.hasRequestId()) {
            this.setRequestId(_other.requestId);
        }
        if (_other.hasResponse()) {
            this.setResponse(_other.response);
        }
        if (_other.hasError()) {
            this.setError(_other.error);
        }
        if (_other.hasMessage()) {
            this.setMessage(_other.getMessage());
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a);
        this.parseFrom(b, b.readableBytes());
    }

    public static enum LookupType {
        Success(0),
        Failed(1);

        private final int value;
        public static final int Success_VALUE = 0;
        public static final int Failed_VALUE = 1;

        private LookupType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static LookupType valueOf(int n) {
            switch (n) {
                case 0: {
                    return Success;
                }
                case 1: {
                    return Failed;
                }
            }
            return null;
        }
    }
}

