/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.service;

import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.UncleanShutdownDetection;
import org.apache.bookkeeper.common.allocator.ByteBufAllocatorWithOomHandler;
import org.apache.bookkeeper.common.component.ComponentInfoPublisher;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieService
extends ServerLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(BookieService.class);
    public static final String NAME = "bookie-server";
    private final BookieServer server;
    private final ByteBufAllocatorWithOomHandler allocator;

    public BookieService(BookieConfiguration conf, Bookie bookie, StatsLogger statsLogger, ByteBufAllocatorWithOomHandler allocator, UncleanShutdownDetection uncleanShutdownDetection) throws Exception {
        super(NAME, conf, statsLogger);
        this.server = BookieServer.newBookieServer(conf.getServerConf(), bookie, statsLogger, (ByteBufAllocator)allocator, uncleanShutdownDetection);
        this.allocator = allocator;
    }

    public void setExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        super.setExceptionHandler(handler);
        this.server.setExceptionHandler(handler);
        this.allocator.setOomHandler(ex -> {
            try {
                log.error("Unable to allocate memory, exiting bookie", (Throwable)ex);
            }
            finally {
                if (this.uncaughtExceptionHandler != null) {
                    this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), (Throwable)ex);
                }
            }
        });
    }

    public BookieServer getServer() {
        return this.server;
    }

    protected void doStart() {
        try {
            this.server.start();
        }
        catch (IOException | InterruptedException exc) {
            throw new RuntimeException("Failed to start bookie server", exc);
        }
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
        this.server.shutdown();
    }

    public void publishInfo(ComponentInfoPublisher componentInfoPublisher) {
        try {
            BookieSocketAddress localAddress = this.getServer().getLocalAddress();
            ArrayList<String> extensions = new ArrayList<String>();
            if (((BookieConfiguration)this.conf).getServerConf().getTLSProviderFactoryClass() != null) {
                extensions.add("tls");
            }
            ComponentInfoPublisher.EndpointInfo endpoint = new ComponentInfoPublisher.EndpointInfo("bookie", localAddress.getPort(), localAddress.getHostName(), "bookie-rpc", null, extensions);
            componentInfoPublisher.publishEndpoint(endpoint);
        }
        catch (UnknownHostException err) {
            log.error("Cannot compute local address", (Throwable)err);
        }
    }
}

