/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.tools;

import java.net.URI;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LocalDLMEmulator;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.admin.DistributedLogAdmin;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.LogReader;
import org.apache.distributedlog.exceptions.ZKException;
import org.apache.distributedlog.tools.DistributedLogTool;
import org.apache.distributedlog.tools.Tool;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDistributedLogTool
extends TestDistributedLogBase {
    static final Logger LOG = LoggerFactory.getLogger(TestDistributedLogTool.class);
    private static final String defaultLedgerPath = LocalDLMEmulator.getBkLedgerPath();
    private static final String defaultPath = "/test/namespace";
    private static final String defaultHost = "127.0.0.1";
    private static final String defaultPrivilegedZkAclId = "NathanielP";
    static URI defaultUri = null;
    static final String ADMIN_TOOL = DistributedLogAdmin.class.getName();

    @BeforeClass
    public static void setupDefaults() throws Exception {
        defaultUri = DLMTestUtil.createDLMURI(zkPort, defaultPath);
        DistributedLogManager dlm = DLMTestUtil.createNewDLM("DefaultStream", conf, defaultUri);
        TestDistributedLogTool.bindStream(defaultUri, defaultLedgerPath, defaultHost);
        DLMTestUtil.generateCompletedLogSegments(dlm, conf, 3L, 8192L);
        dlm.close();
    }

    private static int runTool(String[] args) throws Exception {
        Tool tool = (Tool)ReflectionUtils.newInstance((String)args[0], Tool.class);
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        int rc = tool.run(newArgs);
        Assert.assertTrue((0 == rc ? 1 : 0) != 0);
        return rc;
    }

    static void bindStream(URI uri, String ledgerPath, String zkHosts) throws Exception {
        String[] args = new String[]{ADMIN_TOOL, "bind", "-c", "-l", ledgerPath, "-s", zkHosts, "-f", uri.toString()};
        TestDistributedLogTool.runTool(args);
    }

    static void createStream(URI uri, String prefix, String expression, String zkAclId) throws Exception {
        DistributedLogTool.CreateCommand cmd = new DistributedLogTool.CreateCommand();
        cmd.setUri(defaultUri);
        cmd.setPrefix(prefix);
        cmd.setExpression(expression);
        cmd.setForce(true);
        cmd.setZkAclId(zkAclId);
        Assert.assertEquals((long)0L, (long)cmd.runCmd());
    }

    void deleteStream(URI uri, String stream) throws Exception {
        DistributedLogTool.DeleteCommand cmd = new DistributedLogTool.DeleteCommand();
        cmd.setUri(defaultUri);
        cmd.setStreamName(stream);
        Assert.assertEquals((long)0L, (long)cmd.runCmd());
    }

    void list(URI uri) throws Exception {
        DistributedLogTool.ListCommand cmd = new DistributedLogTool.ListCommand();
        cmd.setUri(defaultUri);
        Assert.assertEquals((long)0L, (long)cmd.runCmd());
    }

    @Test(timeout=60000L)
    public void testToolCreate() throws Exception {
        TestDistributedLogTool.createStream(defaultUri, "0", "TestPrefix", null);
    }

    @Test(timeout=60000L)
    public void testToolCreateZkAclId() throws Exception {
        TestDistributedLogTool.createStream(defaultUri, "0", "CreateAclStream", defaultPrivilegedZkAclId);
        try {
            DistributedLogManager dlm = DLMTestUtil.createNewDLM("0CreateAclStream", conf, defaultUri);
            DLMTestUtil.generateCompletedLogSegments(dlm, conf, 3L, 1000L);
            dlm.close();
        }
        catch (ZKException ex) {
            Assert.assertEquals((Object)KeeperException.Code.NOAUTH, (Object)ex.getKeeperExceptionCode());
        }
    }

    @Test(timeout=60000L)
    public void testToolDelete() throws Exception {
        TestDistributedLogTool.createStream(defaultUri, "1", "TestPrefix", null);
        this.deleteStream(defaultUri, "1TestPrefix");
    }

    @Test(timeout=60000L)
    public void testToolDeleteAllocPool() throws Exception {
        try {
            DistributedLogTool.DeleteAllocatorPoolCommand cmd = new DistributedLogTool.DeleteAllocatorPoolCommand();
            cmd.setUri(defaultUri);
            Assert.assertEquals((long)0L, (long)cmd.runCmd());
            Assert.fail((String)"should have failed");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testToolList() throws Exception {
        this.list(defaultUri);
    }

    @Test(timeout=60000L)
    public void testToolDump() throws Exception {
        DistributedLogTool.DumpCommand cmd = new DistributedLogTool.DumpCommand();
        cmd.setUri(defaultUri);
        cmd.setStreamName("DefaultStream");
        cmd.setFromTxnId(Long.valueOf(0L));
        Assert.assertEquals((long)0L, (long)cmd.runCmd());
    }

    @Test(timeout=60000L)
    public void testToolShow() throws Exception {
        DistributedLogTool.ShowCommand cmd = new DistributedLogTool.ShowCommand();
        cmd.setUri(defaultUri);
        cmd.setStreamName("DefaultStream");
        Assert.assertEquals((long)0L, (long)cmd.runCmd());
    }

    @Test(timeout=60000L)
    public void testToolTruncate() throws Exception {
        DistributedLogManager dlm = DLMTestUtil.createNewDLM("TruncateStream", conf, defaultUri);
        DLMTestUtil.generateCompletedLogSegments(dlm, conf, 3L, 1000L);
        dlm.close();
        DistributedLogTool.TruncateCommand cmd = new DistributedLogTool.TruncateCommand();
        cmd.setUri(defaultUri);
        cmd.setFilter("TruncateStream");
        cmd.setForce(true);
        Assert.assertEquals((long)0L, (long)cmd.runCmd());
    }

    @Test(timeout=60000L)
    public void testToolInspect() throws Exception {
        DistributedLogTool.InspectCommand cmd = new DistributedLogTool.InspectCommand();
        cmd.setUri(defaultUri);
        cmd.setForce(true);
        Assert.assertEquals((long)0L, (long)cmd.runCmd());
    }

    @Test(timeout=60000L)
    public void testToolReadLastConfirmed() throws Exception {
        DistributedLogTool.ReadLastConfirmedCommand cmd = new DistributedLogTool.ReadLastConfirmedCommand();
        cmd.setUri(defaultUri);
        cmd.setLedgerId(99999999L);
        try {
            cmd.runCmd();
        }
        catch (BKException.BKNoSuchLedgerExistsOnMetadataServerException bKNoSuchLedgerExistsOnMetadataServerException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testToolReadEntriesCommand() throws Exception {
        DistributedLogTool.ReadEntriesCommand cmd = new DistributedLogTool.ReadEntriesCommand();
        cmd.setUri(defaultUri);
        cmd.setLedgerId(99999999L);
        try {
            cmd.runCmd();
        }
        catch (BKException.BKNoSuchLedgerExistsOnMetadataServerException bKNoSuchLedgerExistsOnMetadataServerException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testToolTruncateStream() throws Exception {
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.addConfiguration((Configuration)conf);
        confLocal.setLogSegmentCacheEnabled(false);
        DistributedLogManager dlm = DLMTestUtil.createNewDLM("testToolTruncateStream", confLocal, defaultUri);
        DLMTestUtil.generateCompletedLogSegments(dlm, confLocal, 3L, 1000L);
        DLSN dlsn = new DLSN(2L, 1L, 0L);
        DistributedLogTool.TruncateStreamCommand cmd = new DistributedLogTool.TruncateStreamCommand();
        cmd.setDlsn(dlsn);
        cmd.setUri(defaultUri);
        cmd.setStreamName("testToolTruncateStream");
        cmd.setForce(true);
        Assert.assertEquals((long)0L, (long)cmd.runCmd());
        LogReader reader = dlm.getInputStream(0L);
        LogRecordWithDLSN record = reader.readNext(false);
        Assert.assertEquals((Object)dlsn, (Object)record.getDlsn());
        reader.close();
        dlm.close();
    }
}

