/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.common.naming.BundleSplitOption;
import org.apache.pulsar.common.naming.FlowOrQpsEquallyDivideBundleSplitAlgorithm;
import org.apache.pulsar.common.naming.RangeEquallyDivideBundleSplitAlgorithm;
import org.apache.pulsar.common.naming.SpecifiedPositionsBundleSplitAlgorithm;
import org.apache.pulsar.common.naming.TopicCountEquallyDivideBundleSplitAlgorithm;

public interface NamespaceBundleSplitAlgorithm {
    public static final String RANGE_EQUALLY_DIVIDE_NAME = "range_equally_divide";
    public static final String TOPIC_COUNT_EQUALLY_DIVIDE = "topic_count_equally_divide";
    public static final String SPECIFIED_POSITIONS_DIVIDE = "specified_positions_divide";
    public static final String FLOW_OR_QPS_EQUALLY_DIVIDE = "flow_or_qps_equally_divide";
    public static final List<String> AVAILABLE_ALGORITHMS = Lists.newArrayList((Object[])new String[]{"range_equally_divide", "topic_count_equally_divide", "specified_positions_divide", "flow_or_qps_equally_divide"});
    public static final NamespaceBundleSplitAlgorithm RANGE_EQUALLY_DIVIDE_ALGO = new RangeEquallyDivideBundleSplitAlgorithm();
    public static final NamespaceBundleSplitAlgorithm TOPIC_COUNT_EQUALLY_DIVIDE_ALGO = new TopicCountEquallyDivideBundleSplitAlgorithm();
    public static final NamespaceBundleSplitAlgorithm SPECIFIED_POSITIONS_DIVIDE_ALGO = new SpecifiedPositionsBundleSplitAlgorithm();
    public static final NamespaceBundleSplitAlgorithm SPECIFIED_POSITIONS_DIVIDE_FORCE_ALGO = new SpecifiedPositionsBundleSplitAlgorithm(true);
    public static final NamespaceBundleSplitAlgorithm FLOW_OR_QPS_EQUALLY_DIVIDE_ALGO = new FlowOrQpsEquallyDivideBundleSplitAlgorithm();

    public static NamespaceBundleSplitAlgorithm of(String algorithmName) {
        if (algorithmName == null) {
            return null;
        }
        switch (algorithmName) {
            case "range_equally_divide": {
                return RANGE_EQUALLY_DIVIDE_ALGO;
            }
            case "topic_count_equally_divide": {
                return TOPIC_COUNT_EQUALLY_DIVIDE_ALGO;
            }
            case "specified_positions_divide": {
                return SPECIFIED_POSITIONS_DIVIDE_ALGO;
            }
            case "flow_or_qps_equally_divide": {
                return FLOW_OR_QPS_EQUALLY_DIVIDE_ALGO;
            }
        }
        return null;
    }

    public CompletableFuture<List<Long>> getSplitBoundary(BundleSplitOption var1);
}

