/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;

public class ExternalSchemaCompatibilityCheck
implements SchemaCompatibilityCheck {
    @Override
    public SchemaType getSchemaType() {
        return SchemaType.EXTERNAL;
    }

    @Override
    public void checkCompatible(SchemaData from, SchemaData to, SchemaCompatibilityStrategy strategy) throws IncompatibleSchemaException {
        if ((SchemaType.EXTERNAL.equals((Object)from.getType()) || SchemaType.EXTERNAL.equals((Object)to.getType())) && !from.getType().equals((Object)to.getType())) {
            throw new IncompatibleSchemaException("External schema is not compatible with the other schema types.");
        }
    }

    @Override
    public void checkCompatible(Iterable<SchemaData> from, SchemaData to, SchemaCompatibilityStrategy strategy) throws IncompatibleSchemaException {
        for (SchemaData fromSchema : from) {
            this.checkCompatible(fromSchema, to, strategy);
        }
    }
}

