/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.pool;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;

public class SuppressingInheritedAccessControlContextThreadFactory
implements ThreadFactory {
    private final ThreadFactory _defaultThreadFactory = Executors.defaultThreadFactory();
    private final String _threadNamePrefix;
    private final AtomicInteger _threadId = new AtomicInteger();
    private final Subject _subject;

    public SuppressingInheritedAccessControlContextThreadFactory(String threadNamePrefix, Subject subject) {
        this._threadNamePrefix = threadNamePrefix;
        this._subject = subject;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return Subject.doAsPrivileged(this._subject, () -> {
            Thread thread = this._defaultThreadFactory.newThread(runnable);
            if (this._threadNamePrefix != null) {
                thread.setName(this._threadNamePrefix + "-" + this._threadId.getAndIncrement());
            }
            return thread;
        }, null);
    }
}

