/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.plugin.ConfiguredObjectRegistration;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.auth.manager.AnonymousAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.CompositeUsernamePasswordAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.ExternalAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.KerberosAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.MD5AuthenticationProvider;
import org.apache.qpid.server.security.auth.manager.ManagedUser;
import org.apache.qpid.server.security.auth.manager.PlainAuthenticationProvider;
import org.apache.qpid.server.security.auth.manager.ScramSHA1AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.ScramSHA256AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.SimpleLDAPAuthenticationManager;

@PluggableService
public class ConfiguredObjectRegistrationImpl
implements ConfiguredObjectRegistration {
    private final Set<Class<? extends ConfiguredObject>> _implementations;

    public ConfiguredObjectRegistrationImpl() {
        HashSet<Class> implementations = new HashSet<Class>();
        if (!Boolean.getBoolean("qpid.type.disabled:authenticationprovider.SimpleLDAP")) {
            implementations.add(SimpleLDAPAuthenticationManager.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:authenticationprovider.Composite")) {
            implementations.add(CompositeUsernamePasswordAuthenticationManager.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:authenticationprovider.MD5")) {
            implementations.add(MD5AuthenticationProvider.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:authenticationprovider.Anonymous")) {
            implementations.add(AnonymousAuthenticationManager.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:user.managed")) {
            implementations.add(ManagedUser.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:authenticationprovider.Plain")) {
            implementations.add(PlainAuthenticationProvider.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:authenticationprovider.SCRAM-SHA-1")) {
            implementations.add(ScramSHA1AuthenticationManager.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:authenticationprovider.External")) {
            implementations.add(ExternalAuthenticationManager.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:authenticationprovider.SCRAM-SHA-256")) {
            implementations.add(ScramSHA256AuthenticationManager.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:authenticationprovider.Kerberos")) {
            implementations.add(KerberosAuthenticationManager.class);
        }
        this._implementations = Collections.unmodifiableSet(implementations);
    }

    @Override
    public String getType() {
        return "org.apache.qpid.server.security.auth.manager";
    }

    public Set<Class<? extends ConfiguredObject>> getConfiguredObjectClasses() {
        return this._implementations;
    }
}

