/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public class TransportOptions
implements Cloneable {
    public static final int DEFAULT_SEND_BUFFER_SIZE = 65536;
    public static final int DEFAULT_RECEIVE_BUFFER_SIZE = 65536;
    public static final int DEFAULT_TRAFFIC_CLASS = 0;
    public static final boolean DEFAULT_TCP_NO_DELAY = true;
    public static final boolean DEFAULT_TCP_KEEP_ALIVE = false;
    public static final int DEFAULT_SO_LINGER = Integer.MIN_VALUE;
    public static final int DEFAULT_SO_TIMEOUT = -1;
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final int DEFAULT_TCP_PORT = 5672;
    public static final int DEFAULT_SHARED_EVENT_LOOP_THREADS = -1;
    public static final boolean DEFAULT_USE_EPOLL = true;
    public static final boolean DEFAULT_USE_KQUEUE = false;
    public static final boolean DEFAULT_TRACE_BYTES = false;
    public static final String DEFAULT_STORE_TYPE = "jks";
    public static final String DEFAULT_CONTEXT_PROTOCOL = "TLS";
    public static final boolean DEFAULT_TRUST_ALL = false;
    public static final boolean DEFAULT_VERIFY_HOST = true;
    public static final List<String> DEFAULT_DISABLED_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("SSLv2Hello", "SSLv3"));
    public static final int DEFAULT_SSL_PORT = 5671;
    public static final boolean DEFAULT_USE_OPENSSL = false;
    public static final int DEFAULT_LOCAL_PORT = 0;
    private static final String JAVAX_NET_SSL_KEY_STORE = "javax.net.ssl.keyStore";
    private static final String JAVAX_NET_SSL_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String JAVAX_NET_SSL_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String JAVAX_NET_SSL_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    private static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private int sendBufferSize = 65536;
    private int receiveBufferSize = 65536;
    private int trafficClass = 0;
    private int connectTimeout = 60000;
    private int soTimeout = -1;
    private int soLinger = Integer.MIN_VALUE;
    private boolean tcpKeepAlive = false;
    private boolean tcpNoDelay = true;
    private int defaultTcpPort = 5672;
    private String localAddress;
    private int localPort = 0;
    private boolean useEpoll = true;
    private boolean useKQueue = false;
    private boolean traceBytes = false;
    private boolean useOpenSSL = false;
    private int sharedEventLoopThreads = -1;
    private String keyStoreLocation;
    private String keyStorePassword;
    private String trustStoreLocation;
    private String trustStorePassword;
    private String keyStoreType;
    private String trustStoreType;
    private String[] enabledCipherSuites;
    private String[] disabledCipherSuites;
    private String[] enabledProtocols;
    private String[] disabledProtocols = DEFAULT_DISABLED_PROTOCOLS.toArray(new String[0]);
    private String contextProtocol = "TLS";
    private boolean trustAll = false;
    private boolean verifyHost = true;
    private String keyAlias;
    private int defaultSslPort = 5671;
    private SSLContext sslContextOverride;
    private Supplier<?> proxyHandlerSupplier;
    private final Map<String, String> httpHeaders = new HashMap<String, String>();

    public TransportOptions() {
        this.setKeyStoreLocation(System.getProperty(JAVAX_NET_SSL_KEY_STORE));
        this.setKeyStoreType(System.getProperty(JAVAX_NET_SSL_KEY_STORE_TYPE, DEFAULT_STORE_TYPE));
        this.setKeyStorePassword(System.getProperty(JAVAX_NET_SSL_KEY_STORE_PASSWORD));
        this.setTrustStoreLocation(System.getProperty(JAVAX_NET_SSL_TRUST_STORE));
        this.setTrustStoreType(System.getProperty(JAVAX_NET_SSL_TRUST_STORE_TYPE, DEFAULT_STORE_TYPE));
        this.setTrustStorePassword(System.getProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD));
    }

    public TransportOptions clone() {
        return this.copyOptions(new TransportOptions());
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        if (sendBufferSize <= 0) {
            throw new IllegalArgumentException("The send buffer size must be > 0");
        }
        this.sendBufferSize = sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        if (receiveBufferSize <= 0) {
            throw new IllegalArgumentException("The send buffer size must be > 0");
        }
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        if (trafficClass < 0 || trafficClass > 255) {
            throw new IllegalArgumentException("Traffic class must be in the range [0..255]");
        }
        this.trafficClass = trafficClass;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public void setTcpKeepAlive(boolean keepAlive) {
        this.tcpKeepAlive = keepAlive;
    }

    public void setSharedEventLoopThreads(int numThreads) {
        this.sharedEventLoopThreads = numThreads;
    }

    public int getSharedEventLoopThreads() {
        return this.sharedEventLoopThreads;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getDefaultTcpPort() {
        return this.defaultTcpPort;
    }

    public void setDefaultTcpPort(int defaultTcpPort) {
        this.defaultTcpPort = defaultTcpPort;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public boolean isUseEpoll() {
        return this.useEpoll;
    }

    public void setUseEpoll(boolean useEpoll) {
        this.useEpoll = useEpoll;
    }

    public boolean isUseKQueue() {
        return this.useKQueue;
    }

    public void setUseKQueue(boolean useKQueue) {
        this.useKQueue = useKQueue;
    }

    public boolean isTraceBytes() {
        return this.traceBytes;
    }

    public void setTraceBytes(boolean traceBytes) {
        this.traceBytes = traceBytes;
    }

    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    public void setTrustStoreLocation(String trustStoreLocation) {
        this.trustStoreLocation = trustStoreLocation;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setStoreType(String storeType) {
        this.setKeyStoreType(storeType);
        this.setTrustStoreType(storeType);
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getDisabledCipherSuites() {
        return this.disabledCipherSuites;
    }

    public void setDisabledCipherSuites(String[] disabledCipherSuites) {
        this.disabledCipherSuites = disabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public String[] getDisabledProtocols() {
        return this.disabledProtocols;
    }

    public void setDisabledProtocols(String[] disabledProtocols) {
        this.disabledProtocols = disabledProtocols;
    }

    public String getContextProtocol() {
        return this.contextProtocol;
    }

    public void setContextProtocol(String contextProtocol) {
        this.contextProtocol = contextProtocol;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public void setVerifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public int getDefaultSslPort() {
        return this.defaultSslPort;
    }

    public void setDefaultSslPort(int defaultSslPort) {
        this.defaultSslPort = defaultSslPort;
    }

    public void setSslContextOverride(SSLContext sslContextOverride) {
        this.sslContextOverride = sslContextOverride;
    }

    public SSLContext getSslContextOverride() {
        return this.sslContextOverride;
    }

    public <T> Supplier<T> getProxyHandlerSupplier() {
        return this.proxyHandlerSupplier;
    }

    public <T> void setProxyHandlerSupplier(Supplier<T> proxyHandlerFactory) {
        this.proxyHandlerSupplier = proxyHandlerFactory;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public boolean isUseOpenSSL() {
        return this.useOpenSSL;
    }

    public void setUseOpenSSL(boolean useOpenSSL) {
        this.useOpenSSL = useOpenSSL;
    }

    protected TransportOptions copyOptions(TransportOptions copy) {
        copy.setConnectTimeout(this.getConnectTimeout());
        copy.setReceiveBufferSize(this.getReceiveBufferSize());
        copy.setSendBufferSize(this.getSendBufferSize());
        copy.setSoLinger(this.getSoLinger());
        copy.setSoTimeout(this.getSoTimeout());
        copy.setTcpKeepAlive(this.isTcpKeepAlive());
        copy.setTcpNoDelay(this.isTcpNoDelay());
        copy.setTrafficClass(this.getTrafficClass());
        copy.setDefaultTcpPort(this.getDefaultTcpPort());
        copy.setUseEpoll(this.isUseEpoll());
        copy.setTraceBytes(this.isTraceBytes());
        copy.setKeyStoreLocation(this.getKeyStoreLocation());
        copy.setKeyStorePassword(this.getKeyStorePassword());
        copy.setTrustStoreLocation(this.getTrustStoreLocation());
        copy.setTrustStorePassword(this.getTrustStorePassword());
        copy.setKeyStoreType(this.getKeyStoreType());
        copy.setTrustStoreType(this.getTrustStoreType());
        copy.setEnabledCipherSuites(this.getEnabledCipherSuites());
        copy.setDisabledCipherSuites(this.getDisabledCipherSuites());
        copy.setEnabledProtocols(this.getEnabledProtocols());
        copy.setDisabledProtocols(this.getDisabledProtocols());
        copy.setTrustAll(this.isTrustAll());
        copy.setVerifyHost(this.isVerifyHost());
        copy.setKeyAlias(this.getKeyAlias());
        copy.setContextProtocol(this.getContextProtocol());
        copy.setDefaultSslPort(this.getDefaultSslPort());
        copy.setSslContextOverride(this.getSslContextOverride());
        copy.setProxyHandlerSupplier(this.getProxyHandlerSupplier());
        copy.setUseOpenSSL(this.isUseOpenSSL());
        copy.setLocalAddress(this.getLocalAddress());
        copy.setLocalPort(this.getLocalPort());
        copy.setSharedEventLoopThreads(this.getSharedEventLoopThreads());
        return copy;
    }
}

