/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types;

import java.util.Arrays;
import java.util.Objects;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferAllocator;

public interface DeliveryTag {
    public int tagLength();

    public byte[] tagBytes();

    public ProtonBuffer tagBuffer();

    default public void release() {
    }

    public DeliveryTag copy();

    public void writeTo(ProtonBuffer var1);

    public static class ProtonDeliveryTag
    implements DeliveryTag {
        public static final ProtonDeliveryTag EMPTY_TAG = new ProtonDeliveryTag();
        private static final byte[] EMPTY_TAG_ARRAY = new byte[0];
        private final byte[] tagBytes;
        private ProtonBuffer tagView;
        private Integer hashCode;

        public ProtonDeliveryTag() {
            this.tagBytes = EMPTY_TAG_ARRAY;
        }

        public ProtonDeliveryTag(byte[] tagBytes) {
            Objects.requireNonNull(tagBytes, "Tag bytes cannot be null");
            this.tagBytes = tagBytes;
        }

        public ProtonDeliveryTag(ProtonBuffer tagBytes) {
            Objects.requireNonNull(tagBytes, "Tag bytes cannot be null");
            this.tagBytes = new byte[tagBytes.getReadableBytes()];
            tagBytes.copyInto(tagBytes.getReadOffset(), this.tagBytes, 0, this.tagBytes.length);
            this.tagView = tagBytes;
        }

        @Override
        public byte[] tagBytes() {
            return this.tagBytes;
        }

        @Override
        public int tagLength() {
            return this.tagBytes.length;
        }

        @Override
        public ProtonBuffer tagBuffer() {
            if (this.tagView == null) {
                this.tagView = ProtonBufferAllocator.defaultAllocator().copy(this.tagBytes).convertToReadOnly();
            }
            return this.tagView;
        }

        @Override
        public DeliveryTag copy() {
            return new ProtonDeliveryTag(Arrays.copyOf(this.tagBytes, this.tagBytes.length));
        }

        public int hashCode() {
            if (this.hashCode == null) {
                this.hashCode = Arrays.hashCode(this.tagBytes);
            }
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeliveryTag)) {
                return false;
            }
            return Arrays.equals(this.tagBytes, ((DeliveryTag)other).tagBytes());
        }

        public String toString() {
            return "DeliveryTag: {" + Arrays.toString(this.tagBytes) + "}";
        }

        @Override
        public void writeTo(ProtonBuffer buffer) {
            buffer.writeBytes(this.tagBytes);
        }
    }
}

