/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.BandedIterator;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ImageAdapter;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.image.SequenceType;
import org.apache.sis.image.TransferType;
import org.apache.sis.image.WritablePixelIterator;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.pending.jdk.JDK18;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;

public class PixelIterator {
    final RenderedImage image;
    private Raster currentRaster;
    final int numBands;
    final int lowerX;
    final int lowerY;
    final int upperX;
    final int upperY;
    private final int tileWidth;
    private final int tileHeight;
    private final int tileGridXOffset;
    private final int tileGridYOffset;
    private final int tileLowerX;
    private final int tileLowerY;
    private final int tileUpperX;
    private final int tileUpperY;
    private final int windowWidth;
    private final int windowHeight;
    int tileX;
    int tileY;
    int x;
    int y;
    private int currentLowerX;
    private int currentUpperX;
    private int currentUpperY;
    private int windowLimitX;
    private int windowLimitY;
    private final boolean isDefaultOrder;

    PixelIterator(Raster data, Rectangle subArea, Dimension window, SequenceType order) {
        this.image = null;
        this.currentRaster = data;
        this.numBands = data.getNumBands();
        this.tileWidth = data.getWidth();
        this.tileHeight = data.getHeight();
        this.tileGridXOffset = data.getMinX();
        this.tileGridYOffset = data.getMinY();
        Rectangle bounds = PixelIterator.intersection(this.tileGridXOffset, this.tileGridYOffset, this.tileWidth, this.tileHeight, subArea, window);
        this.tileLowerX = 0;
        this.tileLowerY = 0;
        this.tileUpperX = bounds.width == 0 ? 0 : 1;
        this.tileUpperY = bounds.height == 0 ? 0 : 1;
        this.lowerX = bounds.x;
        this.lowerY = bounds.y;
        this.upperX = Math.addExact(this.lowerX, bounds.width);
        this.upperY = Math.addExact(this.lowerY, bounds.height);
        this.windowWidth = window != null ? window.width : 0;
        this.windowHeight = window != null ? window.height : 0;
        this.currentLowerX = this.lowerX;
        this.currentUpperX = this.upperX;
        this.currentUpperY = this.upperY;
        this.windowLimitX = Math.addExact(this.tileGridXOffset, this.tileWidth);
        this.windowLimitY = Math.addExact(this.tileGridYOffset, this.tileHeight);
        this.x = Math.decrementExact(this.lowerX);
        this.y = this.lowerY;
        this.isDefaultOrder = true;
    }

    PixelIterator(RenderedImage data, Rectangle subArea, Dimension window, SequenceType order) {
        this.image = data;
        this.numBands = data.getSampleModel().getNumBands();
        this.tileWidth = data.getTileWidth();
        this.tileHeight = data.getTileHeight();
        this.tileGridXOffset = data.getTileGridXOffset();
        this.tileGridYOffset = data.getTileGridYOffset();
        Rectangle bounds = PixelIterator.intersection(data.getMinX(), data.getMinY(), data.getWidth(), data.getHeight(), subArea, window);
        this.lowerX = bounds.x;
        this.lowerY = bounds.y;
        this.upperX = Math.addExact(this.lowerX, bounds.width);
        this.upperY = Math.addExact(this.lowerY, bounds.height);
        this.tileLowerX = Math.floorDiv(Math.subtractExact(this.lowerX, this.tileGridXOffset), this.tileWidth);
        this.tileLowerY = Math.floorDiv(Math.subtractExact(this.lowerY, this.tileGridYOffset), this.tileHeight);
        this.tileUpperX = JDK18.ceilDiv((int)Math.subtractExact(this.upperX, this.tileGridXOffset), (int)this.tileWidth);
        this.tileUpperY = JDK18.ceilDiv((int)Math.subtractExact(this.upperY, this.tileGridYOffset), (int)this.tileHeight);
        this.windowWidth = window != null ? window.width : 0;
        this.windowHeight = window != null ? window.height : 0;
        this.tileX = Math.decrementExact(this.tileLowerX);
        this.tileY = this.tileLowerY;
        this.currentLowerX = this.lowerX;
        this.currentUpperX = this.lowerX;
        this.currentUpperY = this.lowerY;
        this.x = Math.decrementExact(this.lowerX);
        this.y = this.lowerY;
        boolean bl = this.isDefaultOrder = order == null || this.tileUpperX - this.tileLowerX <= 1;
        if (this.tileUpperY == Integer.MAX_VALUE) {
            throw new ArithmeticException(Errors.format((short)91, (Object)32));
        }
    }

    private static Rectangle intersection(int x, int y, int width, int height, Rectangle subArea, Dimension window) {
        if (window != null) {
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException(Resources.format((short)19));
            }
            ArgumentChecks.ensureBetween((String)"window.width", (int)1, (int)width, (int)window.width);
            ArgumentChecks.ensureBetween((String)"window.height", (int)1, (int)height, (int)window.height);
            width -= window.width - 1;
            height -= window.height - 1;
        }
        Rectangle bounds = new Rectangle(x, y, width, height);
        if (subArea != null) {
            bounds = bounds.intersection(subArea);
            if (bounds.width < 0) {
                bounds.x = x;
                bounds.width = 0;
            }
            if (bounds.height < 0) {
                bounds.y = y;
                bounds.height = 0;
            }
        }
        return bounds;
    }

    public static PixelIterator create(RenderedImage data) {
        return new Builder().create(data);
    }

    public boolean isWritable() {
        return false;
    }

    public DataType getDataType() {
        return DataType.forBands(this.getSampleModel());
    }

    public TransferType<?> getTransferType() {
        return TransferType.valueOf(this.getSampleModel().getTransferType());
    }

    private SampleModel getSampleModel() {
        return this.image != null ? this.image.getSampleModel() : this.currentRaster.getSampleModel();
    }

    public NumberRange<?>[] getSampleRanges() {
        SampleModel model = this.getSampleModel();
        Object[] ranges = new NumberRange[model.getNumBands()];
        if (ranges.length != 0) {
            int dataType = model.getDataType();
            if (ImageUtilities.isIntegerType(dataType)) {
                int lastDefinedBand;
                int bandToDefine = 0;
                do {
                    int size = model.getSampleSize(bandToDefine);
                    long minimum = 0L;
                    long maximum = Numerics.bitmask((int)size) - 1L;
                    if (!DataType.isUnsigned(model)) {
                        minimum = (maximum >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    NumberRange range = dataType == 0 || dataType == 2 ? NumberRange.create((short)((short)minimum), (boolean)true, (short)((short)maximum), (boolean)true) : NumberRange.create((int)((int)minimum), (boolean)true, (int)((int)maximum), (boolean)true);
                    ranges[bandToDefine] = range;
                    lastDefinedBand = bandToDefine;
                    int band = ranges.length;
                    while (--band > lastDefinedBand) {
                        if (ranges[band] != null) continue;
                        if (model.getSampleSize(band) == size) {
                            ranges[band] = range;
                            continue;
                        }
                        bandToDefine = band;
                    }
                } while (bandToDefine > lastDefinedBand);
            } else {
                Arrays.fill(ranges, dataType == 4 ? NumberRange.create((float)Float.NEGATIVE_INFINITY, (boolean)false, (float)Float.POSITIVE_INFINITY, (boolean)false) : NumberRange.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)Double.POSITIVE_INFINITY, (boolean)false));
            }
        }
        return ranges;
    }

    public Optional<SequenceType> getIterationOrder() {
        if (this.isDefaultOrder && this.tileUpperX - this.tileLowerX > 1) {
            return Optional.empty();
        }
        return Optional.of(SequenceType.LINEAR);
    }

    public int getNumBands() {
        return this.numBands;
    }

    public Rectangle getDomain() {
        return new Rectangle(this.lowerX, this.lowerY, this.upperX - this.lowerX, this.upperY - this.lowerY);
    }

    public Point getPosition() {
        int message;
        if (this.x < this.lowerX) {
            message = 39;
        } else if (this.tileY >= this.tileUpperY) {
            message = 38;
        } else {
            return new Point(this.x, this.y);
        }
        throw new IllegalStateException(Resources.format((short)message));
    }

    public void moveTo(int px, int py) {
        if (px < this.lowerX || px >= this.upperX || py < this.lowerY || py >= this.upperY) {
            throw new IndexOutOfBoundsException(Resources.format((short)57, px, py));
        }
        if (this.image != null) {
            int tx = Math.floorDiv(px - this.tileGridXOffset, this.tileWidth);
            int ty = Math.floorDiv(py - this.tileGridYOffset, this.tileHeight);
            if (tx != this.tileX || ty != this.tileY) {
                this.releaseTile();
                this.tileX = tx;
                this.tileY = ty;
                int currentLowerY = this.fetchTile();
                if (currentLowerY > py || py >= this.currentUpperY || this.currentLowerX > px || px >= this.currentUpperX) {
                    throw this.incompatibleTile();
                }
            }
        }
        this.x = px;
        this.y = py;
    }

    public boolean next() {
        if (++this.x >= this.currentUpperX) {
            if (this.isDefaultOrder) {
                if (++this.y >= this.currentUpperY) {
                    this.releaseTile();
                    if (++this.tileX >= this.tileUpperX) {
                        if (++this.tileY >= this.tileUpperY) {
                            this.endOfIteration();
                            return false;
                        }
                        this.tileX = this.tileLowerX;
                    }
                    this.y = this.fetchTile();
                }
                this.x = this.currentLowerX;
            } else {
                this.releaseTile();
                if (this.x < this.upperX) {
                    ++this.tileX;
                } else {
                    if (++this.y >= this.currentUpperY && ++this.tileY >= this.tileUpperY) {
                        this.endOfIteration();
                        return false;
                    }
                    this.tileX = this.tileLowerX;
                    this.x = this.lowerX;
                }
                if (this.fetchTile() > this.y) {
                    throw this.incompatibleTile();
                }
            }
            this.changedRowOrTile();
        }
        return true;
    }

    void changedRowOrTile() {
    }

    final boolean isSameRowAndTile(int px, int py) {
        return py == this.y && px >= this.currentLowerX && px < this.currentUpperX;
    }

    private RasterFormatException incompatibleTile() {
        String inconsistency;
        Object message = Resources.format((short)35, this.tileX, this.tileY);
        if (this.image instanceof PlanarImage && (inconsistency = ((PlanarImage)this.image).verify()) != null) {
            message = (String)message + " " + Messages.format((short)34, (Object)inconsistency);
        }
        return new RasterFormatException((String)message);
    }

    private static boolean isValidTileSize(int actual, int expected, boolean isLast) {
        return isLast ? actual >= 0 && actual <= expected : actual == expected;
    }

    private int fetchTile() {
        Raster tile = this.fetchWritableTile();
        if (tile == null) {
            tile = this.image.getTile(this.tileX, this.tileY);
        }
        Rectangle bounds = tile.getBounds();
        if (tile.getNumBands() != this.numBands || !PixelIterator.isValidTileSize(bounds.width, this.tileWidth, this.tileX == this.tileUpperX - 1) || !PixelIterator.isValidTileSize(bounds.height, this.tileHeight, this.tileY == this.tileUpperY - 1)) {
            throw this.incompatibleTile();
        }
        this.windowLimitX = Math.addExact(bounds.x, bounds.width);
        this.windowLimitY = Math.addExact(bounds.y, bounds.height);
        this.currentUpperX = Math.min(this.upperX, this.windowLimitX);
        this.currentUpperY = Math.min(this.upperY, this.windowLimitY);
        this.currentLowerX = Math.max(this.lowerX, bounds.x);
        this.currentRaster = tile;
        this.acquiredTile(tile);
        return Math.max(this.lowerY, bounds.y);
    }

    Raster fetchWritableTile() {
        return null;
    }

    void acquiredTile(Raster tile) {
    }

    void releaseTile() {
        if (this.image != null) {
            this.currentRaster = null;
        }
    }

    private void endOfIteration() {
        boolean error = this.tileY > Math.max(this.tileUpperY, this.tileLowerY + 1);
        this.x = this.currentUpperX - 1;
        this.y = this.currentUpperY - 1;
        this.tileX = this.tileUpperX - 1;
        this.tileY = this.tileUpperY;
        if (error) {
            throw new IllegalStateException(Resources.format((short)38));
        }
    }

    public int getSample(int band) {
        return this.currentRaster.getSample(this.x, this.y, band);
    }

    public float getSampleFloat(int band) {
        return this.currentRaster.getSampleFloat(this.x, this.y, band);
    }

    public double getSampleDouble(int band) {
        return this.currentRaster.getSampleDouble(this.x, this.y, band);
    }

    public int[] getPixel(int[] dest) {
        return this.currentRaster.getPixel(this.x, this.y, dest);
    }

    public float[] getPixel(float[] dest) {
        return this.currentRaster.getPixel(this.x, this.y, dest);
    }

    public double[] getPixel(double[] dest) {
        return this.currentRaster.getPixel(this.x, this.y, dest);
    }

    public Object getDataElements(Object dest) {
        return this.currentRaster.getDataElements(this.x, this.y, dest);
    }

    public <T extends Buffer> Window<T> createWindow(TransferType<T> type) {
        IntWindow window;
        int length = this.numBands * this.windowWidth * this.windowHeight;
        int transferLength = length - this.numBands * Math.min(this.windowWidth, this.windowHeight);
        switch (type.dataBufferType) {
            case 3: {
                window = new IntWindow(new int[length], new int[transferLength]);
                break;
            }
            case 4: {
                window = this.createWindow(new float[length], new float[transferLength]);
                break;
            }
            case 5: {
                window = this.createWindow(new double[length], new double[transferLength]);
                break;
            }
            default: {
                throw new AssertionError(type);
            }
        }
        return window;
    }

    Window<FloatBuffer> createWindow(float[] data, float[] transfer) {
        return new FloatWindow(data, transfer);
    }

    Window<DoubleBuffer> createWindow(double[] data, double[] transfer) {
        return new DoubleWindow(data, transfer);
    }

    final void fetchValues(Window<?> window, Object data) {
        boolean fullWidth;
        int subEndX = this.windowLimitX - this.x;
        int subEndY = this.windowLimitY - this.y;
        int subWidth = Math.min(this.windowWidth, subEndX);
        int subHeight = Math.min(this.windowHeight, subEndY);
        boolean bl = fullWidth = subWidth == this.windowWidth;
        if (fullWidth && subHeight == this.windowHeight) {
            Object transfer = window.getPixels(this.currentRaster, this.x, this.y, subWidth, subHeight, 0);
            assert (transfer == data);
            return;
        }
        Raster raster = this.currentRaster;
        int mode = 1;
        int destOffset = 0;
        int subX = 0;
        int subY = 0;
        int tileSubX = this.tileX;
        int tileSubY = this.tileY;
        int stride = this.windowWidth * this.numBands;
        int rewind = subEndX;
        while (true) {
            if (subWidth > 0 && subHeight > 0) {
                Object transfer = window.getPixels(raster, this.x + subX, this.y + subY, subWidth, subHeight, mode);
                if (fullWidth) {
                    System.arraycopy(transfer, 0, data, destOffset, stride * subHeight);
                } else {
                    int rowLength = this.numBands * subWidth;
                    int fullLength = rowLength * subHeight;
                    for (int srcOffset = 0; srcOffset < fullLength; srcOffset += rowLength) {
                        System.arraycopy(transfer, srcOffset, data, destOffset, rowLength);
                        destOffset += stride;
                    }
                }
            }
            if (subEndX < this.windowWidth) {
                subX = subEndX;
                subEndX += this.tileWidth;
                ++tileSubX;
            } else {
                if (subEndY >= this.windowHeight) {
                    return;
                }
                subY = subEndY;
                subEndY += this.tileHeight;
                ++tileSubY;
                tileSubX = this.tileX;
                subEndX = rewind;
                subX = 0;
            }
            mode = 2;
            raster = this.image.getTile(tileSubX, tileSubY);
            destOffset = (subY * this.windowWidth + subX) * this.numBands;
            subWidth = Math.min(this.windowWidth, subEndX) - subX;
            subHeight = Math.min(this.windowHeight, subEndY) - subY;
            fullWidth = subWidth == this.windowWidth;
        }
    }

    public void rewind() {
        this.releaseTile();
        if (this.image == null) {
            this.tileX = 0;
            this.tileY = 0;
        } else {
            this.tileX = this.tileLowerX - 1;
            this.tileY = this.tileLowerY;
            this.currentLowerX = this.lowerX;
            this.currentUpperX = this.lowerX;
            this.currentUpperY = this.lowerY;
        }
        this.x = this.lowerX - 1;
        this.y = this.lowerY;
        this.changedRowOrTile();
    }

    public static class Builder {
        private Rectangle subArea;
        private Dimension window;
        private SequenceType order;

        public Builder setRegionOfInterest(Rectangle subArea) {
            if (subArea != null && subArea.isEmpty()) {
                throw new IllegalArgumentException(Resources.format((short)20));
            }
            this.subArea = subArea;
            return this;
        }

        public Builder setWindowSize(Dimension window) {
            this.window = window;
            return this;
        }

        public Builder setIteratorOrder(SequenceType order) {
            if (order != null && !order.equals((Object)SequenceType.LINEAR)) {
                throw new IllegalArgumentException(Errors.format((short)200, (Object)((Object)order)));
            }
            this.order = order;
            return this;
        }

        private static RenderedImage unwrap(RenderedImage image) {
            while (image instanceof ImageAdapter) {
                image = ((ImageAdapter)image).source;
            }
            return image;
        }

        static int getScanlineStride(SampleModel sm) {
            MultiPixelPackedSampleModel csm;
            if (sm instanceof ComponentSampleModel) {
                ComponentSampleModel csm2 = (ComponentSampleModel)sm;
                if (csm2.getPixelStride() == 1) {
                    for (int offset : csm2.getBandOffsets()) {
                        if (offset == 0) continue;
                        return 0;
                    }
                    if (ArraysExt.isRange((int)0, (int[])csm2.getBankIndices())) {
                        return csm2.getScanlineStride();
                    }
                }
            } else if (sm instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel csm3 = (SinglePixelPackedSampleModel)sm;
                int[] offsets = csm3.getBitOffsets();
                if (offsets.length == 1 && offsets[0] == 0) {
                    return csm3.getScanlineStride();
                }
            } else if (sm instanceof MultiPixelPackedSampleModel && (csm = (MultiPixelPackedSampleModel)sm).getDataBitOffset() == 0 && csm.getPixelBitStride() == DataBuffer.getDataTypeSize(csm.getDataType())) {
                return csm.getScanlineStride();
            }
            return 0;
        }

        public PixelIterator create(Raster data) {
            int scanlineStride = Builder.getScanlineStride(data.getSampleModel());
            if (scanlineStride > 0) {
                return new BandedIterator(data, null, this.subArea, this.window, this.order, scanlineStride);
            }
            return new PixelIterator(data, this.subArea, this.window, this.order);
        }

        public PixelIterator create(RenderedImage data) {
            if ((data = Builder.unwrap(Objects.requireNonNull(data))) instanceof BufferedImage) {
                return this.create(((BufferedImage)data).getRaster());
            }
            int scanlineStride = Builder.getScanlineStride(data.getSampleModel());
            if (scanlineStride > 0) {
                return new BandedIterator(data, null, this.subArea, this.window, this.order, scanlineStride);
            }
            return new PixelIterator(data, this.subArea, this.window, this.order);
        }

        public WritablePixelIterator createWritable(WritableRaster data) {
            return this.createWritable(Objects.requireNonNull(data), data);
        }

        public WritablePixelIterator createWritable(WritableRenderedImage data) {
            if (Objects.requireNonNull(data) instanceof BufferedImage) {
                return this.createWritable(((BufferedImage)data).getRaster());
            }
            return this.createWritable(data, data);
        }

        public WritablePixelIterator createWritable(Raster input, WritableRaster output) {
            ArgumentChecks.ensureNonNull((String)"input", (Object)input);
            ArgumentChecks.ensureNonNull((String)"output", (Object)output);
            int scanlineStride = Builder.getScanlineStride(input.getSampleModel());
            if (scanlineStride > 0) {
                return new BandedIterator(input, output, this.subArea, this.window, this.order, scanlineStride);
            }
            return new WritablePixelIterator(input, output, this.subArea, this.window, this.order);
        }

        public WritablePixelIterator createWritable(RenderedImage input, WritableRenderedImage output) {
            ArgumentChecks.ensureNonNull((String)"input", (Object)input);
            ArgumentChecks.ensureNonNull((String)"output", (Object)output);
            input = Builder.unwrap(input);
            int scanlineStride = Builder.getScanlineStride(input.getSampleModel());
            if (scanlineStride > 0) {
                return new BandedIterator(input, output, this.subArea, this.window, this.order, scanlineStride);
            }
            return new WritablePixelIterator(input, output, this.subArea, this.window, this.order);
        }
    }

    private final class IntWindow
    extends Window<IntBuffer> {
        private final int[] data;
        private final int[] transfer;

        IntWindow(int[] data, int[] transfer) {
            super(IntBuffer.wrap(data).asReadOnlyBuffer());
            this.data = data;
            this.transfer = transfer;
        }

        @Override
        final PixelIterator owner() {
            return PixelIterator.this;
        }

        @Override
        Object getPixels(Raster raster, int subX, int subY, int subWidth, int subHeight, int mode) {
            return raster.getPixels(subX, subY, subWidth, subHeight, mode == 0 ? this.data : this.transfer);
        }

        @Override
        public void update() {
            ((IntBuffer)this.values).clear();
            PixelIterator.this.fetchValues(this, this.data);
        }
    }

    public static abstract class Window<T extends Buffer> {
        static final int DIRECT = 0;
        static final int TRANSFER = 1;
        static final int TRANSFER_FROM_OTHER = 2;
        public final T values;

        Window(T buffer) {
            this.values = buffer;
        }

        abstract PixelIterator owner();

        public final Dimension getSize() {
            PixelIterator it = this.owner();
            return new Dimension(it.windowWidth, it.windowHeight);
        }

        public abstract void update();

        abstract Object getPixels(Raster var1, int var2, int var3, int var4, int var5, int var6);
    }

    private final class FloatWindow
    extends Window<FloatBuffer> {
        private final float[] data;
        private final float[] transfer;

        FloatWindow(float[] data, float[] transfer) {
            super(FloatBuffer.wrap(data).asReadOnlyBuffer());
            this.data = data;
            this.transfer = transfer;
        }

        @Override
        final PixelIterator owner() {
            return PixelIterator.this;
        }

        @Override
        Object getPixels(Raster raster, int subX, int subY, int subWidth, int subHeight, int mode) {
            return raster.getPixels(subX, subY, subWidth, subHeight, mode == 0 ? this.data : this.transfer);
        }

        @Override
        public void update() {
            ((FloatBuffer)this.values).clear();
            PixelIterator.this.fetchValues(this, this.data);
        }
    }

    private final class DoubleWindow
    extends Window<DoubleBuffer> {
        private final double[] data;
        private final double[] transfer;

        DoubleWindow(double[] data, double[] transfer) {
            super(DoubleBuffer.wrap(data).asReadOnlyBuffer());
            this.data = data;
            this.transfer = transfer;
        }

        @Override
        final PixelIterator owner() {
            return PixelIterator.this;
        }

        @Override
        Object getPixels(Raster raster, int subX, int subY, int subWidth, int subHeight, int mode) {
            return raster.getPixels(subX, subY, subWidth, subHeight, mode == 0 ? this.data : this.transfer);
        }

        @Override
        public void update() {
            ((DoubleBuffer)this.values).clear();
            PixelIterator.this.fetchValues(this, this.data);
        }
    }
}

