/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql.internal.shared;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import org.apache.sis.metadata.sql.internal.shared.Dialect;
import org.apache.sis.metadata.sql.internal.shared.Syntax;
import org.apache.sis.metadata.sql.internal.shared.TypeMapper;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.internal.shared.Strings;

public class SQLBuilder
extends Syntax {
    public static final String SELECT = "SELECT ";
    public static final String INSERT = "INSERT INTO ";
    public static final String DELETE = "DELETE FROM ";
    protected final StringBuilder buffer = new StringBuilder(200);

    public SQLBuilder(DatabaseMetaData metadata, boolean quoteSchema) throws SQLException {
        super(metadata, quoteSchema);
    }

    public SQLBuilder(Syntax other) {
        super(other);
    }

    public final boolean isEmpty() {
        return this.buffer.length() == 0;
    }

    public final SQLBuilder clear() {
        this.buffer.setLength(0);
        return this;
    }

    public final SQLBuilder append(int n) {
        this.buffer.append(n);
        return this;
    }

    public final SQLBuilder append(long n) {
        this.buffer.append(n);
        return this;
    }

    public final SQLBuilder append(char c) {
        this.buffer.append(c);
        return this;
    }

    public final SQLBuilder append(String text, int start, int end) {
        this.buffer.append(text, start, end);
        return this;
    }

    public final SQLBuilder append(String keyword) {
        this.buffer.append(keyword);
        return this;
    }

    public final SQLBuilder appendIdentifier(String name) {
        this.buffer.append(this.identifierQuote).append(name).append(this.identifierQuote);
        return this;
    }

    public final SQLBuilder appendIdentifier(String schema, String name) {
        return this.appendIdentifier(null, schema, name, true);
    }

    public final SQLBuilder appendIdentifier(String catalog, String schema, String name, boolean quoteName) {
        boolean showCatalog;
        boolean showSchema = !Strings.isNullOrEmpty((String)schema) && !schema.equals(this.currentSchema);
        boolean bl = showCatalog = !Strings.isNullOrEmpty((String)catalog) && !catalog.equals(this.currentCatalog) && !Strings.isNullOrEmpty((String)this.catalogSeparator);
        if (showCatalog && this.isCatalogAtStart) {
            this.appendIdentifier(catalog).append(this.catalogSeparator);
            showSchema = true;
            if (schema == null) {
                schema = "";
            }
        }
        if (showSchema) {
            if (this.quoteSchema) {
                this.appendIdentifier(schema);
            } else {
                this.append(schema);
            }
            this.append('.');
        }
        if (quoteName) {
            this.appendIdentifier(name);
        } else {
            this.append(name);
        }
        if (showCatalog && !this.isCatalogAtStart) {
            this.append(this.catalogSeparator).appendIdentifier(catalog);
        }
        return this;
    }

    public final SQLBuilder appendEqualsValue(Object value) {
        return value == null ? this.append(" IS NULL") : this.append('=').appendValue(value);
    }

    public final SQLBuilder appendValue(String value) {
        return value == null ? this.append("NULL") : this.append('\'').append(value.replace("'", "''")).append('\'');
    }

    public final SQLBuilder appendValue(Object value) {
        if (value instanceof Number) {
            this.buffer.append(value);
        } else if (value instanceof Boolean) {
            this.buffer.append((Boolean)value != false ? "TRUE" : "FALSE");
        } else if (value instanceof TemporalAccessor) {
            TemporalAccessor t = (TemporalAccessor)value;
            LocalDate date = t.query(TemporalQueries.localDate());
            LocalTime time = t.query(TemporalQueries.localTime());
            if (time == null && date == null) {
                return this.appendValue(value.toString());
            }
            this.buffer.append('\'');
            if (date != null) {
                this.buffer.append(date);
                if (time != null) {
                    this.buffer.append(' ');
                }
            }
            if (time != null) {
                this.buffer.append(time);
                ZoneOffset zone = t.query(TemporalQueries.offset());
                if (zone != null) {
                    this.buffer.append(zone);
                }
            }
            this.buffer.append('\'');
        } else {
            return this.appendValue(value != null ? value.toString() : (String)null);
        }
        return this;
    }

    public final SQLBuilder appendWildcardEscaped(String value) {
        int start = this.buffer.length();
        this.buffer.append(value);
        if (this.canEscapeWildcards()) {
            char escapeChar = this.wildcardEscape.charAt(0);
            int i = this.buffer.length();
            while (--i >= start) {
                char c = this.buffer.charAt(i);
                if (c != '_' && c != '%' && (c != escapeChar || !value.startsWith(this.wildcardEscape, i))) continue;
                this.buffer.insert(i, this.wildcardEscape);
            }
        }
        return this;
    }

    public final SQLBuilder appendFetchPage(long offset, long count) {
        if (offset > 0L) {
            this.buffer.append(" OFFSET ").append(offset).append(" ROW");
            if (offset > 1L) {
                this.buffer.append('S');
            }
        }
        if (count > 0L) {
            this.buffer.append(" FETCH ").append(offset <= 0L ? "FIRST" : "NEXT").append(' ').append(count).append(" ROW");
            if (count > 1L) {
                this.buffer.append('S');
            }
            this.buffer.append(" ONLY");
        }
        return this;
    }

    public final SQLBuilder insertDistinctAfterSelect() {
        assert (CharSequences.startsWith((CharSequence)this.buffer, (CharSequence)SELECT, (boolean)false)) : this.buffer;
        this.buffer.insert(SELECT.length(), "DISTINCT ");
        return this;
    }

    public final SQLBuilder removeWhereClause() {
        int index = this.buffer.indexOf(" WHERE ");
        if (index >= 0) {
            this.buffer.setLength(index);
        }
        return this;
    }

    public final String createColumn(String schema, String table, String column, Class<?> type, int maxLength) {
        this.clear().append("ALTER TABLE ").appendIdentifier(schema, table).append(" ADD COLUMN ").appendIdentifier(column).append(' ');
        String sqlType = TypeMapper.keywordFor(type);
        if (sqlType != null) {
            this.append(sqlType);
        } else {
            this.append("VARCHAR(").append(maxLength).append(')');
        }
        return this.toString();
    }

    public final String createForeignKey(String schema, String table, String column, String target, String primaryKey, boolean cascade) {
        if (this.dialect == Dialect.DERBY) {
            cascade = false;
        }
        this.buffer.setLength(0);
        String name = this.buffer.append(table).append('_').append(column).append("_fkey").toString();
        return this.clear().append("ALTER TABLE ").appendIdentifier(schema, table).append(" ADD CONSTRAINT ").appendIdentifier(name).append(" FOREIGN KEY(").appendIdentifier(column).append(") REFERENCES ").appendIdentifier(schema, target).append(" (").appendIdentifier(primaryKey).append(") ON UPDATE ").append(cascade ? "CASCADE" : "RESTRICT").append(" ON DELETE RESTRICT").toString();
    }

    public final String toString() {
        return this.buffer.toString();
    }
}

