/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal.shared;

import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.Matrix;

public interface ExtendedPrecisionMatrix
extends Matrix {
    public static final Number[] CREATE_ZERO = new Number[0];
    public static final Number[] CREATE_IDENTITY = new Number[0];

    public static boolean isZero(Number element) {
        return element == null || element.doubleValue() == 0.0;
    }

    public static ExtendedPrecisionMatrix castOrWrap(final Matrix m) {
        if (m == null || m instanceof ExtendedPrecisionMatrix) {
            return (ExtendedPrecisionMatrix)m;
        }
        return new ExtendedPrecisionMatrix(){

            @Override
            public Number getElementOrNull(int j, int i) {
                double v = m.getElement(j, i);
                return v != 0.0 ? Double.valueOf(v) : null;
            }

            @Override
            public double getElement(int j, int i) {
                return m.getElement(j, i);
            }

            public int getNumRow() {
                return m.getNumRow();
            }

            public int getNumCol() {
                return m.getNumCol();
            }

            public String toString() {
                return m.toString();
            }

            public Matrix clone() {
                return m.clone();
            }

            public boolean isIdentity() {
                return m.isIdentity();
            }
        };
    }

    default public Number[] getElementAsNumbers(boolean writable) {
        int numCol = this.getNumCol();
        Number[] elements = new Number[this.getNumRow() * numCol];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = this.getElementOrNull(i / numCol, i % numCol);
        }
        return elements;
    }

    public Number getElementOrNull(int var1, int var2);

    default public double getElement(int row, int column) {
        Number value = this.getElementOrNull(row, column);
        return value != null ? value.doubleValue() : 0.0;
    }

    default public void setElement(int row, int column, double value) {
        throw new UnsupportedOperationException(Errors.format((short)185, this.getClass()));
    }
}

