/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.provider.Equirectangular;
import org.apache.sis.referencing.operation.provider.LambertConformal2SP;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.IdentifiedObject;

final class ESRI {
    static final ParameterDescriptor<Double> CENTRAL_MERIDIAN;
    static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    static final ParameterDescriptor<Double> STANDARD_PARALLEL_1;
    static final ParameterDescriptor<Double> STANDARD_PARALLEL_2;
    static final ParameterDescriptor<Double> FALSE_EASTING;
    static final ParameterDescriptor<Double> FALSE_NORTHING;

    private ESRI() {
    }

    static ParameterBuilder copyNames(ParameterBuilder builder, ParameterDescriptor<Double> template) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addNameAndIdentifier((Citation)Citations.ESRI, (IdentifiedObject)template)).addNameAndIdentifier((Citation)Citations.OGC, (IdentifiedObject)template)).addNameAndIdentifier((Citation)Citations.GEOTIFF, (IdentifiedObject)template)).addNameAndIdentifier((Citation)Citations.PROJ4, (IdentifiedObject)template);
    }

    static {
        ParameterBuilder builder = new ParameterBuilder().setRequired(true);
        CENTRAL_MERIDIAN = MapProjection.createLongitude(ESRI.copyNames(builder, Equirectangular.LONGITUDE_OF_ORIGIN));
        LATITUDE_OF_ORIGIN = MapProjection.createLatitude(ESRI.copyNames(builder, Equirectangular.LATITUDE_OF_ORIGIN), true);
        STANDARD_PARALLEL_1 = MapProjection.createLatitude(ESRI.copyNames(builder, LambertConformal2SP.STANDARD_PARALLEL_1), true);
        STANDARD_PARALLEL_2 = MapProjection.createLatitude(ESRI.copyNames(builder, LambertConformal2SP.STANDARD_PARALLEL_2), true);
        FALSE_EASTING = MapProjection.createShift(ESRI.copyNames(builder, Equirectangular.FALSE_EASTING));
        FALSE_NORTHING = MapProjection.createShift(ESRI.copyNames(builder, Equirectangular.FALSE_NORTHING));
    }
}

